/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.runner;

import fit.Counts;
import fit.Parse;
import fitlibrary.differences.FolderRunnerDifference;
import fitlibrary.exception.FitLibraryException;
import fitlibrary.runner.CopyFiles;
import fitlibrary.runner.CustomRunnerException;
import fitlibrary.runner.HtmlRunner;
import fitlibrary.runner.Report;
import fitlibrary.runner.ReportHtml;
import fitlibrary.runner.SpreadsheetRunner;
import fitlibrary.runner.TestListener;
import fitlibrary.suite.BatchFitLibrary;
import fitlibrary.traverse.Traverse;
import fitlibrary.utility.ParseUtility;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class FolderRunner {
    private static final String FILES = "files";
    public static final String INDEX_HTML = "reportIndex.html";
    protected String encoding = "ASCII";
    private static final Set SETUPS = new HashSet<String>(Arrays.asList("SETUP.XLS", "SETUP.HTML", "SETUP.HTM"));
    private static final Set TEARDOWNS = new HashSet<String>(Arrays.asList("TEARDOWN.XLS", "TEARDOWN.HTML", "TEARDOWN.HTM"));
    private Report topReport;
    private List testListeners = new ArrayList();
    private File inDiry;
    private File reportDiry;
    private File suiteFile;
    private BatchFitLibrary batchFitLibrary = new BatchFitLibrary();

    public static void main(String[] args) throws ParseException, IOException {
        Report report = new FolderRunner(args).run();
        report.exit();
    }

    public FolderRunner() {
        Traverse.setFolderRunnerStrategy();
    }

    public FolderRunner(String[] args) {
        this();
        int prefixArgs = 0;
        if (args.length > 1 && args[0].equals("-s")) {
            prefixArgs = 2;
            this.setSuiteFile(args[1]);
        }
        switch (args.length - prefixArgs) {
            case 0: {
                this.setTestFile("tests");
                break;
            }
            case 1: {
                this.setTestFile(args[prefixArgs]);
                break;
            }
            case 2: {
                this.setFiles(args[prefixArgs], args[prefixArgs + 1]);
                break;
            }
            case 3: {
                this.setFiles(args[prefixArgs], args[prefixArgs + 1]);
                this.encoding = args[prefixArgs + 2];
                break;
            }
            default: {
                System.err.println("Usage: java fitlibrary.runner.FolderRunner\nOr:    java fitlibrary.runner.FolderRunner testFolder\nOr:    java fitlibrary.runner.FolderRunner testFolder reportFolder\nOr:    java fitlibrary.runner.FolderRunner testFolder reportFolder unicodeEncodingOr:    java fitlibrary.runner.FolderRunner -s suiteFileName testFolder\nOr:    java fitlibrary.runner.FolderRunner -s suiteFileName testFolder reportFolder\nOr:    java fitlibrary.runner.FolderRunner -s suiteFileName testFolder reportFolder unicodeEncoding");
                System.exit(-1);
            }
        }
    }

    private void setSuiteFile(String fileName) {
        this.suiteFile = new File(fileName);
    }

    public Report run(String testDiry) throws ParseException, IOException {
        this.setTestFile(testDiry);
        return this.run();
    }

    public Report run(String theInDiry, String theReportDiry) throws ParseException, IOException {
        this.setFiles(theInDiry, theReportDiry);
        return this.run();
    }

    public Report run() throws ParseException, IOException {
        if (!this.inDiry.exists() || !this.inDiry.isDirectory()) {
            throw new RuntimeException("Folder is needed for input: " + this.inDiry.getAbsolutePath());
        }
        if (this.reportDiry.exists()) {
            if (!this.reportDiry.isDirectory()) {
                throw new RuntimeException("File exists but is not a directory: " + this.reportDiry.getAbsolutePath());
            }
        } else if (!this.reportDiry.mkdir()) {
            throw new RuntimeException("Unable to create folder " + this.reportDiry.getAbsolutePath());
        }
        if (this.reportDiry.getAbsolutePath().startsWith(this.inDiry.getAbsolutePath())) {
            throw new RuntimeException("The reports folder can't be inside the tests folder: it'll run forever!");
        }
        this.copyCssAndImageFilesFromJar(this.inDiry);
        Parse setUpTables = new Parse("table", "", null, null);
        Parse tearDownTables = null;
        String title = "";
        File topReportDiry = this.reportDiry;
        this.topReport = new Report("FolderRunner", this.reportDiry, "", topReportDiry);
        File reportFile = new File(this.reportDiry, INDEX_HTML);
        if (FolderRunner.fileIsLocked(reportFile)) {
            throw new RuntimeException("Already running");
        }
        if (this.suiteFile != null) {
            this.runSuite(this.suiteFile, this.reportDiry, this.topReport, setUpTables, tearDownTables);
        }
        this.runDiry(title, this.inDiry, this.reportDiry, this.topReport, setUpTables, tearDownTables, "", topReportDiry);
        this.giveFeedbackToUser();
        this.suiteFinished();
        this.topReport.setFinished();
        this.writeReport(reportFile, this.topReport);
        return this.topReport;
    }

    private void runDiry(String title, File theInDiry, File theReportDiry, Report parentReport, Parse setUpTables, Parse tearDownTables, String path, File topReportDiry) throws ParseException, IOException {
        FolderRunnerDifference.setCurrentTestDiryFile(theInDiry);
        Report report = new Report(title, theReportDiry, parentReport, path, topReportDiry);
        Parse fullSetUpTables = this.appendSetUp(setUpTables, theInDiry);
        Parse fullTearDownTables = this.prependTearDown(tearDownTables, theInDiry);
        File filesFile = new File(theInDiry, FILES);
        if (filesFile.exists()) {
            CopyFiles.copyFilesRecursively(theInDiry, theReportDiry, FILES);
        }
        File[] files = theInDiry.listFiles();
        for (int i = 0; i < files.length; ++i) {
            this.giveFeedbackToUser();
            File file = files[i];
            String name = file.getName();
            if (file.isDirectory()) {
                if (!this.canRunThisFolder(name)) continue;
                File subReportDiry = new File(theReportDiry, name);
                if (!subReportDiry.exists()) {
                    subReportDiry.mkdir();
                }
                this.runDiry(title + "." + file.getName(), file, subReportDiry, report, fullSetUpTables, fullTearDownTables, path + "../", topReportDiry);
                FolderRunnerDifference.setCurrentTestDiryFile(theInDiry);
                continue;
            }
            if (FolderRunner.specialFileName(name)) continue;
            this.runFile(file, theReportDiry, report, fullSetUpTables, fullTearDownTables);
        }
        report.setFinished();
    }

    private void writeReport(File reportFile, Report report) throws IOException {
        Report reportToWrite = report;
        if (report.hasSingleChild()) {
            reportToWrite = report.firstChild();
        }
        PrintWriter output = new PrintWriter(new BufferedWriter(new FileWriter(reportFile)));
        output.print(reportToWrite.getHtml());
        output.close();
    }

    private void runSuite(File theSuiteFile, File theReportDiry, Report parentReport, Parse setUpTables, Parse tearDownTables) {
        if (!theSuiteFile.exists() || theSuiteFile.isDirectory()) {
            throw new RuntimeException("Suite file doesn't exist or is not a file: " + theSuiteFile);
        }
        Report report = new Report(theSuiteFile.getName(), theReportDiry, parentReport, "", theReportDiry);
        this.runFile(theSuiteFile, theReportDiry, report, setUpTables, tearDownTables);
        report.setFinished();
    }

    private boolean canRunThisFolder(String name) {
        return !name.equals(FILES) && !name.startsWith(".") && !name.equals("CVS");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runFile(File file, File theReportDiry, Report report, Parse fullSetUpTables, Parse fullTearDownTables) {
        block7: {
            String name = file.getName();
            PrintStream oldOut = System.out;
            PrintStream oldErr = System.err;
            ByteArrayOutputStream tempOut = new ByteArrayOutputStream();
            ByteArrayOutputStream tempErr = new ByteArrayOutputStream();
            try {
                if (FolderRunner.isXlsFileName(name) || FolderRunner.isHtmlFileName(name)) {
                    System.setOut(new PrintStream(tempOut));
                    System.setErr(new PrintStream(tempErr));
                    File reportFile = new File(theReportDiry, FolderRunner.reportName(file));
                    if (FolderRunner.fileIsLocked(reportFile)) {
                        throw new RuntimeException("File is locked");
                    }
                    Parse setUp = this.copyParse(fullSetUpTables.more);
                    Parse tearDown = this.copyParse(fullTearDownTables);
                    Traverse.setContext(theReportDiry);
                    Counts counts = FolderRunner.isXlsFileName(name) ? new SpreadsheetRunner(report).run(file, reportFile, setUp, tearDown, this.batchFitLibrary) : new HtmlRunner(report).runInSuite(file, reportFile, this.encoding, setUp, tearDown, this.batchFitLibrary);
                    report.addAssertionCountsForPage(reportFile, counts);
                    break block7;
                }
                throw new RuntimeException("Not HTML nor XLS");
            }
            catch (Exception e) {
                this.ignoreFile(file, e);
            }
            finally {
                this.reportOutput(name, "out", tempOut.toString());
                this.reportOutput(name, "err", tempErr.toString());
                System.setOut(oldOut);
                System.setErr(oldErr);
            }
        }
    }

    private static boolean fileIsLocked(File file) {
        return file.exists() && !file.canWrite();
    }

    public static boolean specialFileName(String mixedCaseName) {
        String name = mixedCaseName.toUpperCase();
        return SETUPS.contains(name) || TEARDOWNS.contains(name);
    }

    private Parse appendSetUp(Parse tables, File theInDiry) throws IOException {
        Parse newTables = this.copyParse(tables);
        this.gatherTables(theInDiry, SETUPS, newTables.last());
        return newTables;
    }

    private Parse copyParse(Parse parse) {
        return ParseUtility.copyParse(parse);
    }

    private Parse prependTearDown(Parse tables, File theInDiry) throws IOException {
        Parse newTables = new Parse("", "", null, null);
        this.gatherTables(theInDiry, TEARDOWNS, newTables);
        ParseUtility.append(newTables, this.copyParse(tables));
        return newTables.more;
    }

    private static String reportName(File file) {
        return ReportHtml.reportName(file);
    }

    private Parse gatherTables(File theInDiry, Set matching, Parse endTable) throws FileNotFoundException, IOException {
        File xlsFile = null;
        File htmlFile = null;
        File[] files = theInDiry.listFiles();
        for (int i = 0; i < files.length; ++i) {
            File file = files[i];
            String name = file.getName().toUpperCase();
            if (!matching.contains(name)) continue;
            if (FolderRunner.isXlsFileName(name)) {
                xlsFile = file;
            } else {
                if (htmlFile != null) {
                    throw new RuntimeException("Can't have .html and .htm files in " + theInDiry.getAbsolutePath());
                }
                htmlFile = file;
            }
            endTable = endTable.last();
        }
        try {
            if (xlsFile != null) {
                ParseUtility.append(endTable, new SpreadsheetRunner().collectTable(xlsFile));
            }
        }
        catch (CustomRunnerException e) {
            this.ignoreFile(htmlFile, e);
        }
        try {
            if (htmlFile != null) {
                ParseUtility.append(endTable, new HtmlRunner().collectTable(htmlFile, this.encoding));
            }
        }
        catch (ParseException e) {
            this.ignoreFile(htmlFile, e);
        }
        return endTable;
    }

    private void ignoreFile(File file, Exception e) {
        System.out.println("Ignored file: " + file.getAbsolutePath() + " due to: " + e);
    }

    public static boolean isHtmlFileName(String name) {
        String upperName = name.toUpperCase();
        return upperName.endsWith(".HTML") || upperName.endsWith(".HTM");
    }

    public static boolean isXlsFileName(String name) {
        return name.toUpperCase().endsWith(".XLS");
    }

    private void copyCssAndImageFilesFromJar(File theInDiry) throws IOException {
        File cssDiry;
        File filesDiry = new File(theInDiry, FILES);
        if (!filesDiry.exists()) {
            filesDiry.mkdir();
        }
        if (!(cssDiry = new File(filesDiry, "css")).exists()) {
            cssDiry.mkdir();
        }
        this.createFileIfNeeded(new File(cssDiry, "fitnesse.css"), "css/fitnesse.css");
        File imagesDiry = new File(filesDiry, "images");
        if (!imagesDiry.exists()) {
            imagesDiry.mkdir();
        }
        this.createFileIfNeeded(new File(imagesDiry, "collapsableClosed.gif"), "images/collapsableClosed.gif");
        this.createFileIfNeeded(new File(imagesDiry, "collapsableOpen.gif"), "images/collapsableClosed.gif");
    }

    private void createFileIfNeeded(File target, String resource) throws FileNotFoundException, IOException {
        int ch;
        if (target.exists()) {
            return;
        }
        ClassLoader classLoader = ClassLoader.getSystemClassLoader();
        InputStream reader = classLoader.getResourceAsStream(resource);
        if (reader == null) {
            throw new FitLibraryException("Unable to access resource from jar: " + resource);
        }
        BufferedOutputStream writer = new BufferedOutputStream(new FileOutputStream(target));
        while ((ch = reader.read()) >= 0) {
            writer.write(ch);
        }
        reader.close();
        writer.close();
    }

    private void setTestFile(String testDiryName) {
        this.inDiry = new File(testDiryName);
        this.reportDiry = new File(this.inDiry.getParentFile(), "reports");
    }

    private void setFiles(String testDiryName, String reportDiryName) {
        this.inDiry = new File(testDiryName);
        this.reportDiry = new File(reportDiryName);
    }

    public void addTestListener(TestListener listener) {
        this.testListeners.add(listener);
    }

    private void giveFeedbackToUser() {
        Iterator it = this.testListeners.iterator();
        while (it.hasNext()) {
            ((TestListener)it.next()).testComplete(this.topReport.failing(), this.topReport.getCounts(), this.topReport.getAssertionCounts());
        }
    }

    private void reportOutput(String name, String out, String message) {
        Iterator it = this.testListeners.iterator();
        while (it.hasNext()) {
            ((TestListener)it.next()).reportOutput(name, out, message);
        }
    }

    private void suiteFinished() {
        Iterator it = this.testListeners.iterator();
        while (it.hasNext()) {
            ((TestListener)it.next()).suiteComplete();
        }
    }

    public void exit() {
        this.topReport.exit();
    }
}

