/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.runner;

import fit.Counts;
import fit.Parse;
import fit.exception.FitParseException;
import fitlibrary.runner.Report;
import fitlibrary.suite.BatchFitLibrary;
import fitlibrary.table.Tables;
import fitlibrary.utility.ParseUtility;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.text.ParseException;

public class HtmlRunner {
    private Report report;

    public HtmlRunner() {
    }

    public HtmlRunner(Report report) {
        this.report = report;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Counts runInSuite(File inFile, File theReport, String encoding, Parse setUp, Parse tearDown, BatchFitLibrary batchFitLibrary) throws IOException {
        if (!theReport.canWrite()) {
            // empty if block
        }
        PrintWriter output = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(theReport), encoding));
        String fileContents = this.read(inFile, encoding);
        if (fileContents.indexOf("<i>[Not a TEST]</i>") >= 0) {
            output.print(fileContents);
            output.close();
            return new Counts(0, 0, 0, 0);
        }
        try {
            Parse tables = new Parse(fileContents);
            Parse whole = HtmlRunner.integrateSetUpAndTearDown(tables, setUp, tearDown);
            Counts counts = batchFitLibrary.doTables(new Tables(whole)).getCounts();
            whole.print(output);
            Counts counts2 = counts;
            return counts2;
        }
        catch (FitParseException e) {
            output.print(fileContents);
            Counts counts = new Counts();
            return counts;
        }
        catch (Exception e) {
            e.printStackTrace();
            Counts counts = new Counts(0, 0, 0, 0);
            return counts;
        }
        finally {
            output.close();
        }
    }

    public Parse getParse(File inFile, String encoding) throws ParseException, IOException {
        return new Parse(this.read(inFile, encoding));
    }

    public static Parse integrateSetUpAndTearDown(Parse tables, Parse setUp, Parse tearDown) {
        Parse whole = tables;
        if (setUp != null) {
            whole = setUp;
            ParseUtility.appendToSetUp(whole, tables);
        }
        if (tearDown != null) {
            ParseUtility.append(whole, tearDown);
        }
        return whole;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String read(File input, String encoding) throws IOException {
        StringBuffer result;
        BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(input), encoding));
        try {
            String s;
            result = new StringBuffer();
            while ((s = in.readLine()) != null) {
                result.append(s);
                result.append("\n");
            }
        }
        finally {
            in.close();
        }
        String string = result.toString();
        if (this.report == null) {
            return string;
        }
        return this.report.addLinks(string, input);
    }

    public Parse collectTable(File file, String encoding) throws ParseException, IOException {
        return this.getParse(file, encoding);
    }
}

