/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.spec;

import fit.Parse;
import fitlibrary.exception.table.NestedTableExpectedException;
import fitlibrary.exception.table.RowWrongWidthException;
import fitlibrary.spec.SpecifyFixture;
import fitlibrary.suite.BatchFitLibrary;
import fitlibrary.table.Cell;
import fitlibrary.table.Row;
import fitlibrary.table.Table;
import fitlibrary.table.Tables;
import fitlibrary.utility.ParseUtility;
import fitlibrary.utility.TestResults;

public class SpecifySuiteFixture
extends SpecifyFixture {
    public void doTable(Parse table) {
        this.doTable(new Table(table));
    }

    private void doTable(Table theTable) {
        TestResults testResults = new TestResults(this.counts);
        BatchFitLibrary batch = new BatchFitLibrary();
        for (int rowNo = 1; rowNo < theTable.size(); ++rowNo) {
            Row row = theTable.row(rowNo);
            if (row.size() < 2) {
                theTable.error(testResults, (Throwable)new RowWrongWidthException(2));
            }
            Cell test = row.cell(0);
            Cell report = row.cell(1);
            if (!test.hasEmbeddedTable()) {
                theTable.error(testResults, (Throwable)new NestedTableExpectedException());
                return;
            }
            Parse actual = test.getEmbeddedTables().parse();
            Parse expected = report.getEmbeddedTables().parse();
            batch.doTables(new Tables(actual));
            if (SpecifySuiteFixture.reportsEqual(actual, expected)) {
                report.pass(testResults);
                continue;
            }
            report.fail(testResults);
            ParseUtility.printParse(actual, "actual");
            this.addTableToBetterShowDifferences(theTable.parse, actual, expected);
        }
        batch.exit();
    }
}

