/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.suite;

import fit.FixtureBridge;
import fitlibrary.suite.IndependentSuiteRunner;
import fitlibrary.suite.IntegratedSuiteRunner;
import fitlibrary.suite.Reportage;
import fitlibrary.suite.SuiteEvaluator;
import fitlibrary.suite.SuiteRunner;
import fitlibrary.table.Tables;
import fitlibrary.utility.TableListener;
import fitlibrary.utility.TestResults;

public class BatchFitLibrary {
    private boolean first = true;
    private SuiteRunner suiteRunner;
    private TableListener tableListener = new TableListener();
    private Reportage reportage;

    public BatchFitLibrary() {
        this(new DefaultReportage());
    }

    public BatchFitLibrary(Reportage reportage) {
        this.reportage = reportage;
    }

    public BatchFitLibrary(TableListener tableListener) {
        this.tableListener = tableListener;
    }

    public TestResults doTables(Tables theTables) {
        this.tableListener.clearTestResults();
        if (this.first) {
            this.first = false;
            FixtureBridge fixtureBridge = new FixtureBridge();
            fixtureBridge.counts = this.tableListener.getTestResults().getCounts();
            Object firstObjectOfSuite = fixtureBridge.firstObject(theTables.parse(), this.tableListener.getTestResults());
            if (firstObjectOfSuite == null) {
                theTables.ignoreAndFinished(this.tableListener);
                return this.tableListener.getTestResults();
            }
            if (firstObjectOfSuite instanceof SuiteEvaluator) {
                this.suiteRunner = new IntegratedSuiteRunner((SuiteEvaluator)firstObjectOfSuite);
                this.reportage.showAllReports();
            } else {
                this.suiteRunner = new IndependentSuiteRunner(firstObjectOfSuite);
            }
            this.suiteRunner.runFirstStorytest(theTables, this.tableListener);
        } else {
            this.suiteRunner.runStorytest(theTables, this.tableListener);
        }
        return this.tableListener.getTestResults();
    }

    public void doTables(Tables theTables, TableListener listener) {
        this.tableListener = listener;
        this.doTables(theTables);
    }

    public void exit() {
        this.suiteRunner.exit();
    }

    public static class DefaultReportage
    implements Reportage {
        public void showAllReports() {
        }
    }
}

