/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.suite;

import fit.FitServerBridge;
import fit.Parse;
import fitlibrary.suite.BatchFitLibrary;
import fitlibrary.suite.Reportage;
import fitlibrary.table.Tables;
import fitlibrary.traverse.Traverse;
import fitlibrary.typed.TypedFactory;
import fitlibrary.utility.TableListener;
import fitlibrary.utility.TestResults;

public class FitLibraryServer
extends FitServerBridge
implements Reportage {
    private BatchFitLibrary batching = new BatchFitLibrary(this);

    public FitLibraryServer(String host, int port, boolean verbose) {
        super(host, port, verbose);
        FitLibraryServer.installGenericProcessing();
    }

    public FitLibraryServer() {
        FitLibraryServer.installGenericProcessing();
    }

    public void doTables(Parse parseTables) {
        this.fixture.counts = this.doTables(new Tables(parseTables)).getCounts();
    }

    public TestResults doTables(Tables theTables) {
        TableListener tableListener = new TableListener(this.fixtureListener);
        this.batching.doTables(theTables, tableListener);
        return tableListener.getTestResults();
    }

    public void exit() throws Exception {
        this.batching.exit();
        super.exit();
    }

    public static void installGenericProcessing() {
        try {
            Class<?> typedFactory = Class.forName("fitlibrary2.typed.GenericTypedFactory");
            Traverse.installTypedFactory((TypedFactory)typedFactory.newInstance());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void main(String[] args) throws Exception {
        FitLibraryServer fitServer = new FitLibraryServer();
        fitServer.run(args);
        System.exit(fitServer.exitCode());
    }
}

