/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.suite;

import fit.Fixture;
import fit.FixtureBridge;
import fitlibrary.DomainFixture;
import fitlibrary.suite.InFlowPageRunner;
import fitlibrary.suite.SuiteRunner;
import fitlibrary.table.Table;
import fitlibrary.table.Tables;
import fitlibrary.traverse.AlienTraverseHandler;
import fitlibrary.traverse.Evaluator;
import fitlibrary.traverse.Traverse;
import fitlibrary.traverse.workflow.DoEvaluator;
import fitlibrary.utility.TableListener;

public class IndependentSuiteRunner
implements SuiteRunner {
    private static final AlienTraverseHandler alienTraverseHandler = Traverse.getAlienTraverseHandler();
    private Object firstObjectOfFirstStorytest;

    public IndependentSuiteRunner(Object firstObjectOfFirstStorytest) {
        this.firstObjectOfFirstStorytest = firstObjectOfFirstStorytest;
    }

    public void runFirstStorytest(Tables tables, TableListener tableListener) {
        this.runEachStorytest(this.firstObjectOfFirstStorytest, tables, tableListener);
    }

    public void runStorytest(Tables tables, TableListener tableListener) {
        Object firstObject = new FixtureBridge().firstObject(tables.parse(), tableListener.getTestResults());
        this.runEachStorytest(firstObject, tables, tableListener);
    }

    private void runEachStorytest(Object object, Tables tables, TableListener tableListener) {
        if (object == null) {
            tables.ignoreAndFinished(tableListener);
            return;
        }
        if (!this.evaluator(object)) {
            object = new DomainFixture(object);
        }
        if (object instanceof DoEvaluator) {
            DoEvaluator doEvaluator = (DoEvaluator)object;
            Table firstTable = tables.table(0);
            doEvaluator.interpret(firstTable, tableListener.getTestResults());
            tableListener.tableFinished(firstTable);
            new InFlowPageRunner(doEvaluator, false).run(tables, 1, tableListener);
            tableListener.storytestFinished();
        } else {
            Fixture fixture = new Fixture();
            fixture.listener = tableListener.getListener();
            fixture.counts = tableListener.getTestResults().getCounts();
            fixture.doTables(tables.parse());
        }
    }

    private boolean evaluator(Object object) {
        return alienTraverseHandler.isAlienTraverse(object) || object instanceof Evaluator;
    }

    public void exit() {
    }
}

