/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.table;

import fit.Parse;
import fitlibrary.exception.table.MissingCellsException;
import fitlibrary.table.Cell;
import fitlibrary.table.ParseNode;
import fitlibrary.utility.ParseUtility;
import fitlibrary.utility.TestResults;

public class Row
extends ParseNode {
    private boolean rowIsHidden = false;

    public Row(Parse parse) {
        super(parse);
    }

    public Row() {
        this(new Parse("tr", "", null, null));
    }

    public int size() {
        if (this.parse.parts == null) {
            return 0;
        }
        return this.parse.parts.size();
    }

    public Cell cell(int i) {
        if (!this.cellExists(i)) {
            throw new MissingCellsException("");
        }
        return new Cell(this.parse.parts.at(i));
    }

    public boolean cellExists(int i) {
        return i >= 0 && i < this.size();
    }

    public String toString() {
        return "Row[" + ParseUtility.toString(this.parse.parts) + "]";
    }

    public void pass(TestResults testResults) {
        if (this.rowIsHidden) {
            System.out.println("Bug: colouring a cell in a hidden table");
        }
        super.pass(testResults);
    }

    public void fail(TestResults testResults) {
        if (this.rowIsHidden) {
            System.out.println("Bug: colouring a cell in a hidden table");
        }
        super.fail(testResults);
    }

    public void error(TestResults testResults, Throwable e) {
        this.cell(0).error(testResults, e);
    }

    public String text(int i) {
        return this.cell(i).text();
    }

    public void missing(TestResults testResults) {
        this.cell(0).expectedElementMissing(testResults);
    }

    public Cell addCell() {
        Cell cell = new Cell("");
        this.addCell(cell);
        return cell;
    }

    public void addCell(Cell cell) {
        if (this.rowIsHidden) {
            System.out.println("Bug: Adding a cell to a hidden row in a table");
        }
        if (this.parse.parts == null) {
            this.parse.parts = cell.parse;
        } else {
            this.parse.parts.last().more = cell.parse;
        }
    }

    public Cell addCell(String text) {
        Cell cell = new Cell(text);
        this.addCell(cell);
        return cell;
    }

    public Cell addCell(String text, int cols) {
        Cell cell = new Cell(text, cols);
        this.addCell(cell);
        return cell;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Row)) {
            return false;
        }
        Row other = (Row)object;
        if (other.size() != this.size()) {
            return false;
        }
        for (int i = 0; i < this.size(); ++i) {
            if (this.cell(i).equals(other.cell(i))) continue;
            return false;
        }
        return true;
    }

    public Row rowFrom(int i) {
        return new Row(new Parse("tr", "", this.parse.parts.at(i), null));
    }

    public Cell last() {
        return this.cell(this.size() - 1);
    }

    public void ignore(TestResults testResults) {
        for (int i = 0; i < this.size(); ++i) {
            this.cell(i).ignore(testResults);
        }
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public void setIsHidden() {
        this.rowIsHidden = true;
        for (int i = 0; i < this.size(); ++i) {
            this.cell(i).setIsHidden();
        }
    }

    public Cell lastCell() {
        return this.cell(this.size() - 1);
    }
}

