/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.traverse;

import fitlibrary.closure.CalledMethodTarget;
import fitlibrary.closure.Closure;
import fitlibrary.closure.LookupMethodTarget;
import fitlibrary.differences.DifferenceInterface;
import fitlibrary.differences.FitNesseDifference;
import fitlibrary.differences.FolderRunnerDifference;
import fitlibrary.differences.LocalFile;
import fitlibrary.exception.CycleException;
import fitlibrary.parser.lookup.ParseDelegation;
import fitlibrary.table.Table;
import fitlibrary.traverse.AlienTraverseHandler;
import fitlibrary.traverse.DomainAdapter;
import fitlibrary.traverse.Evaluator;
import fitlibrary.typed.NonGenericTypedFactory;
import fitlibrary.typed.NonGenericTypedObject;
import fitlibrary.typed.Typed;
import fitlibrary.typed.TypedFactory;
import fitlibrary.typed.TypedObject;
import fitlibrary.utility.ExtendedCamelCase;
import fitlibrary.utility.TestResults;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public abstract class Traverse
implements Evaluator {
    protected static DifferenceInterface FITNESSE_DIFFERENCES = new FitNesseDifference();
    protected static AlienTraverseHandler ALIEN_TRAVERSE_HANDLER = new AlienTraverseHandler();
    private static TypedFactory factory = new NonGenericTypedFactory();
    private TypedObject typedObjectUnderTest = new NonGenericTypedObject(null);
    private Evaluator outerContext = null;
    private boolean setUpAlreadyCalled = false;
    private boolean tearDownAlreadyCalled = false;
    protected boolean canTearDown = true;

    public Traverse() {
    }

    public Traverse(Object sut) {
        this.setSystemUnderTest(sut);
    }

    public Traverse(TypedObject typedObjectUnderTest) {
        this.typedObjectUnderTest = typedObjectUnderTest;
    }

    protected void registerParseDelegate(Class type, Class parseDelegate) {
        ParseDelegation.registerParseDelegate(type, parseDelegate);
    }

    protected void registerParseDelegate(Class type, Object parseDelegate) {
        ParseDelegation.registerParseDelegate(type, parseDelegate);
    }

    public void setSystemUnderTest(Object sut) {
        if (this.cycleSUT(this, sut)) {
            throw new CycleException("systemUnderTest", this, sut);
        }
        this.typedObjectUnderTest = Traverse.asTypedObject(sut);
    }

    private boolean cycleSUT(DomainAdapter domainAdapter, Object sut) {
        if (domainAdapter == sut) {
            return true;
        }
        if (sut instanceof DomainAdapter) {
            return this.cycleSUT(domainAdapter, ((DomainAdapter)sut).getSystemUnderTest());
        }
        return false;
    }

    public Object getSystemUnderTest() {
        if (this.typedObjectUnderTest == null) {
            return null;
        }
        return this.typedObjectUnderTest.getSubject();
    }

    public TypedObject getTypedSystemUnderTest() {
        return this.typedObjectUnderTest;
    }

    public void setTypedSystemUnderTest(TypedObject typedObjectUnderTest) {
        this.typedObjectUnderTest = typedObjectUnderTest;
    }

    public void setOuterContext(Evaluator outerContext) {
        if (this.outerContext == outerContext || this == outerContext) {
            return;
        }
        if (Traverse.cycleOC(this, outerContext)) {
            throw new CycleException("outerContext", this, outerContext);
        }
        this.outerContext = outerContext;
    }

    private static boolean cycleOC(DomainAdapter domainAdapter, Evaluator oc) {
        if (domainAdapter == oc) {
            return true;
        }
        if (oc != null) {
            return Traverse.cycleOC(domainAdapter, oc.getNextOuterContext());
        }
        return false;
    }

    public Evaluator getNextOuterContext() {
        return this.outerContext;
    }

    public Object getOutermostContext() {
        Evaluator context = this.getNextOuterContext();
        if (context == null) {
            return this;
        }
        return context.getOutermostContext();
    }

    public static void setFolderRunnerStrategy() {
        FITNESSE_DIFFERENCES = new FolderRunnerDifference();
    }

    public static LocalFile getLocalFile(String localFileName) {
        return FITNESSE_DIFFERENCES.getLocalFile(localFileName);
    }

    public static String htmlLink(File file) {
        return FITNESSE_DIFFERENCES.getGlobalFile(file).htmlLink();
    }

    public static void setContext(File reportDiry) {
        FITNESSE_DIFFERENCES.setContext(reportDiry);
    }

    public static String escapeHtml(String s) {
        return FITNESSE_DIFFERENCES.escapeHtml(s);
    }

    protected String camelCase(String suppliedName) {
        return ExtendedCamelCase.camel(suppliedName);
    }

    public void theSetUpTearDownAlreadyHandled() {
        this.setUpAlreadyCalled = true;
        this.tearDownAlreadyCalled = true;
    }

    public void setUp(Table table, TestResults testResults) {
        if (this.setUpAlreadyCalled) {
            return;
        }
        this.setUpAlreadyCalled = true;
        try {
            CalledMethodTarget methodTarget = this.asTypedObject().optionallyFindMethodOnTypedObject("setUp", 0, this, false);
            if (methodTarget == null) {
                return;
            }
            methodTarget.invoke();
        }
        catch (Exception e) {
            table.error(testResults, (Throwable)e);
        }
    }

    public void tearDown(Table table, TestResults testResults) {
        if (!this.canTearDown || this.tearDownAlreadyCalled) {
            return;
        }
        this.tearDownAlreadyCalled = true;
        try {
            CalledMethodTarget methodTarget = this.asTypedObject().optionallyFindMethodOnTypedObject("tearDown", 0, this, false);
            if (methodTarget == null) {
                return;
            }
            methodTarget.invoke();
        }
        catch (Exception e) {
            table.error(testResults, (Throwable)e);
        }
    }

    public void interpretWithinContext(Table table, Evaluator evaluator, TestResults testResults) {
        this.setOuterContext(evaluator);
        this.interpret(table, testResults);
    }

    public void interpretInnerTable(Table table, Evaluator evaluator, TestResults testResults) {
        this.setOuterContext(evaluator);
        this.interpret(table.withDummyFirstRow(), testResults);
    }

    public boolean doesInnerTablePass(Table table, Evaluator evaluator, TestResults testResults) {
        TestResults innerResults = new TestResults();
        this.interpretInnerTable(table, evaluator, innerResults);
        testResults.add(innerResults);
        return innerResults.passed();
    }

    public boolean doesTablePass(Table table, Evaluator evaluator, TestResults testResults) {
        this.setOuterContext(evaluator);
        TestResults innerResults = new TestResults();
        this.interpret(table, innerResults);
        testResults.add(innerResults);
        return innerResults.passed();
    }

    public static AlienTraverseHandler getAlienTraverseHandler() {
        return ALIEN_TRAVERSE_HANDLER;
    }

    public static void setAlienTraverseHandler(AlienTraverseHandler handler) {
        ALIEN_TRAVERSE_HANDLER = handler;
    }

    public static void installTypedFactory(TypedFactory installedFactory) {
        factory = installedFactory;
    }

    public static Typed asTyped(Class type) {
        return factory.asTyped(type);
    }

    public static Typed asTyped(Object object) {
        return factory.asTyped(object.getClass());
    }

    public static Typed asTyped(Method method) {
        return factory.asTyped(method);
    }

    protected TypedObject asTypedObject() {
        return factory.asTypedObject(this);
    }

    public static TypedObject asTypedObject(Object sut) {
        if (sut instanceof TypedObject) {
            return (TypedObject)sut;
        }
        return factory.asTypedObject(sut);
    }

    public void callStartCreatingObjectMethod(TypedObject object) throws IllegalAccessException, InvocationTargetException {
        if (object != null) {
            this.callCreatingMethod("startCreatingObject", object.getSubject());
        }
    }

    public void callStartCreatingObjectMethod(Object element) throws IllegalAccessException, InvocationTargetException {
        this.callCreatingMethod("startCreatingObject", element);
    }

    public void callEndCreatingObjectMethod(TypedObject object) throws IllegalAccessException, InvocationTargetException {
        if (object != null) {
            this.callCreatingMethod("endCreatingObject", object.getSubject());
        }
    }

    public void callEndCreatingObjectMethod(Object element) throws IllegalAccessException, InvocationTargetException {
        this.callCreatingMethod("endCreatingObject", element);
    }

    private void callCreatingMethod(String creatingMethodName, Object element) throws IllegalAccessException, InvocationTargetException {
        Closure startCreatingMethod = LookupMethodTarget.findFixturingMethod(this, creatingMethodName, new Class[]{Object.class});
        if (startCreatingMethod != null) {
            startCreatingMethod.invoke(new Object[]{element});
        }
    }

    public abstract Object interpret(Table var1, TestResults var2);
}

