/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.traverse.function;

import fitlibrary.closure.CalledMethodTarget;
import fitlibrary.closure.LookupMethodTarget;
import fitlibrary.exception.FitLibraryExceptionWithHelp;
import fitlibrary.exception.method.VoidMethodException;
import fitlibrary.table.Cell;
import fitlibrary.table.Row;
import fitlibrary.table.Table;
import fitlibrary.traverse.function.FunctionTraverse;
import fitlibrary.typed.TypedObject;
import fitlibrary.utility.ExtendedCamelCase;
import fitlibrary.utility.TestResults;
import java.util.ArrayList;

public class CalculateTraverse
extends FunctionTraverse {
    private CalledMethodTarget[] targets;
    private int methods = 0;
    private boolean notesPermitted = false;
    private boolean hasNotes = false;
    protected int argCount = -1;
    protected boolean boundOK = false;

    public CalculateTraverse() {
    }

    public CalculateTraverse(Object sut) {
        this.setSystemUnderTest(sut);
    }

    public CalculateTraverse(TypedObject typedObject) {
        this.setTypedSystemUnderTest(typedObject);
    }

    public Object interpret(Table table, TestResults testResults) {
        this.methods = 0;
        this.bindFirstRowToTarget(table.row(1), testResults);
        for (int i = 2; i < table.size(); ++i) {
            this.processRow(table.row(i), testResults);
        }
        return null;
    }

    public void processRow(Row row, TestResults testResults) {
        if (!this.boundOK) {
            row.ignore(testResults);
            return;
        }
        if (this.hasNotes) {
            if (row.size() < this.argCount + this.methods + 1) {
                row.error(testResults, new FitLibraryExceptionWithHelp("Row should be at least " + (this.argCount + this.methods + 1) + " cells wide", "CalculateRowTooShort"));
                return;
            }
        } else if (row.size() != this.argCount + this.methods + 1) {
            row.error(testResults, new FitLibraryExceptionWithHelp("Row should be " + (this.argCount + this.methods + 1) + " cells wide", "CalculateRowWrongLength"));
            return;
        }
        for (int i = 0; i < this.methods; ++i) {
            this.targets[i].invokeAndCheck(row, row.cell(i + this.argCount + 1), testResults, true);
        }
    }

    public void bindFirstRowToTarget(Row row, TestResults testResults) {
        boolean pastDoubleColumn = false;
        int rowLength = row.size();
        String argNames = "";
        ArrayList<String> arguments = new ArrayList<String>();
        for (int i = 0; i < rowLength; ++i) {
            Cell cell = row.cell(i);
            String name = cell.text();
            try {
                if (name.equals("")) {
                    if (pastDoubleColumn && this.notesPermitted) {
                        this.hasNotes = true;
                        break;
                    }
                    this.argCount = i;
                    arguments.add("arg" + (i + 1));
                    this.targets = new CalledMethodTarget[rowLength - i - 1];
                    pastDoubleColumn = true;
                    continue;
                }
                this.notesPermitted = true;
                if (pastDoubleColumn) {
                    CalledMethodTarget target;
                    String methodName = this.camelCase(name + argNames);
                    if (arguments.size() > this.argCount) {
                        arguments.remove(arguments.size() - 1);
                    }
                    if ((target = LookupMethodTarget.findTheMethod(methodName, arguments, "TypeOfResult", this)).returnsVoid()) {
                        throw new VoidMethodException(methodName, "CalculateTraverse");
                    }
                    this.targets[this.methods] = target;
                    ++this.methods;
                    target.setRepeatAndExceptionString(this.repeatString, this.exceptionString);
                    continue;
                }
                arguments.add(ExtendedCamelCase.camel(name));
                argNames = argNames + " " + name;
                continue;
            }
            catch (Exception e) {
                cell.error(testResults, e);
                return;
            }
        }
        if (this.methods == 0) {
            row.error(testResults, new FitLibraryExceptionWithHelp("No calculated column", "NoCalculateColumn"));
        }
        this.boundOK = true;
    }
}

