/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.traverse.workflow;

import fitlibrary.closure.CalledMethodTarget;
import fitlibrary.closure.LookupMethodTarget;
import fitlibrary.closure.MethodTarget;
import fitlibrary.collection.CollectionSetUpTraverse;
import fitlibrary.exception.FitLibraryException;
import fitlibrary.exception.FitLibraryExceptionWithHelp;
import fitlibrary.exception.IgnoredException;
import fitlibrary.exception.NotRejectedException;
import fitlibrary.exception.method.AmbiguousActionException;
import fitlibrary.exception.method.MissingMethodException;
import fitlibrary.exception.parse.ParseException;
import fitlibrary.exception.table.ExtraCellsException;
import fitlibrary.exception.table.MissingCellsException;
import fitlibrary.parser.graphic.GraphicParser;
import fitlibrary.parser.graphic.ObjectDotGraphic;
import fitlibrary.suite.FlowControl;
import fitlibrary.suite.InFlowPageRunner;
import fitlibrary.table.Cell;
import fitlibrary.table.Row;
import fitlibrary.table.Table;
import fitlibrary.table.Tables;
import fitlibrary.traverse.CommentTraverse;
import fitlibrary.traverse.Evaluator;
import fitlibrary.traverse.Traverse;
import fitlibrary.traverse.function.CalculateTraverse;
import fitlibrary.traverse.function.ConstraintTraverse;
import fitlibrary.traverse.workflow.DefineTemplateTraverse;
import fitlibrary.traverse.workflow.DoEvaluator;
import fitlibrary.traverse.workflow.UseTemplateTraverse;
import fitlibrary.typed.NonGenericTyped;
import fitlibrary.typed.TypedObject;
import fitlibrary.utility.ClassUtility;
import fitlibrary.utility.ExtendedCamelCase;
import fitlibrary.utility.TableListener;
import fitlibrary.utility.TestResults;

public class DoTraverse
extends Traverse
implements DoEvaluator {
    private boolean gatherExpectedForGeneration;
    private Object expectedResult = new Boolean(true);
    private CollectionSetUpTraverse setUpTraverse = null;
    private boolean settingUp = true;
    private FlowControl flowControl = new FlowControl(){

        public void abandon() {
        }

        public void setStopOnError(boolean stopOnError) {
        }
    };

    protected DoTraverse() {
    }

    public DoTraverse(Object sut) {
        super(sut);
    }

    public DoTraverse(TypedObject typedObject) {
        super(typedObject);
    }

    public Object interpret(Table table, TestResults testResults) {
        Object result = null;
        this.setUp(table, testResults);
        int size = table.size();
        for (int rowNo = 1; rowNo < size; ++rowNo) {
            Row row = table.row(rowNo);
            try {
                result = this.interpretRow(row, testResults);
                if (result instanceof DoEvaluator) {
                    DoEvaluator resultingEvaluator = (DoEvaluator)result;
                    resultingEvaluator.interpretInFlow(new Table(row), testResults);
                    break;
                }
                if (result instanceof Evaluator) {
                    Evaluator resultingEvaluator = (Evaluator)result;
                    resultingEvaluator.interpret(new Table(row), testResults);
                    break;
                }
                if (!DoTraverse.getAlienTraverseHandler().isAlienTraverse(result)) continue;
                DoTraverse.getAlienTraverseHandler().doTable(result, new Table(row), testResults);
                break;
            }
            catch (Exception ex) {
                row.error(testResults, ex);
            }
        }
        this.tearDown(table, testResults);
        return result;
    }

    public Object interpretWholeTable(Table table, TableListener tableListener) {
        TestResults testResults = tableListener.getTestResults();
        try {
            Object result = this.interpretRow(table.row(0), testResults);
            if (result instanceof Evaluator) {
                Evaluator resultingEvaluator = (Evaluator)result;
                resultingEvaluator.interpret(table, testResults);
                return result;
            }
            if (!DoTraverse.getAlienTraverseHandler().isAlienTraverse(result)) {
                return this.interpretInFlow(table, testResults);
            }
            DoTraverse.getAlienTraverseHandler().doTable(result, table, testResults);
        }
        catch (Throwable e) {
            table.error(testResults, e);
        }
        return null;
    }

    public Object interpretInFlow(Table table, TestResults testResults) {
        return this.interpret(table, testResults);
    }

    public Object interpretRow(Row row, TestResults testResults) {
        Cell cell = row.cell(0);
        if (cell.hasEmbeddedTable()) {
            this.setExpectedResult(null);
            this.interpretInnerTables(cell.innerTables(), testResults);
            return null;
        }
        this.setExpectedResult(new Boolean(true));
        String methodName = row.text(0);
        if (!methodName.equals("")) {
            methodName = ExtendedCamelCase.camel(methodName);
        }
        try {
            DoTraverse switchedSetUp = this.switchSetUp();
            CalledMethodTarget specialMethod = switchedSetUp.findSpecialMethod(row.text(0));
            DoTraverse.checkForAmbiguity(methodName, specialMethod, null);
            try {
                CalledMethodTarget target = switchedSetUp.findMethodByActionName(row, row.size() - 1);
                DoTraverse.checkForAmbiguity(methodName, specialMethod, target);
                Object result = target.invokeAndWrap(row.rowFrom(1), testResults);
                if (result instanceof Boolean) {
                    target.color(row, (Boolean)result, testResults);
                }
                return result;
            }
            catch (MissingMethodException e) {
                if (specialMethod == null) {
                    throw e;
                }
                return specialMethod.invoke(new Object[]{row, testResults});
            }
        }
        catch (IgnoredException ex) {
        }
        catch (Exception ex) {
            cell.error(testResults, ex);
        }
        return null;
    }

    private void interpretInnerTables(Tables tables, TestResults testResults) {
        new InFlowPageRunner(this, false).run(tables, 0, new TableListener(testResults));
    }

    public void check(Row row, TestResults testResults) throws Exception {
        int less = 3;
        if (row.size() < less) {
            throw new MissingCellsException("DoTraverseCheck");
        }
        CalledMethodTarget target = this.findMethodFromRow(row, less);
        Cell expectedCell = row.last();
        if (this.gatherExpectedForGeneration) {
            this.expectedResult = target.getResult(expectedCell, testResults);
        }
        target.invokeAndCheck(row.rowFrom(2), expectedCell, testResults, false);
    }

    public void reject(Row row, TestResults testResults) throws Exception {
        this.not(row, testResults);
    }

    public void not(Row row, TestResults testResults) throws Exception {
        Cell notCell = row.cell(0);
        this.expectedResult = new Boolean(false);
        try {
            Object result = this.callMethodInRow(row, testResults, false);
            if (!(result instanceof Boolean)) {
                notCell.error(testResults, new NotRejectedException());
            } else if (((Boolean)result).booleanValue()) {
                notCell.fail(testResults);
            } else {
                notCell.pass(testResults);
            }
        }
        catch (IgnoredException e) {
        }
        catch (FitLibraryException e) {
            if (e instanceof ParseException) {
                notCell.pass(testResults);
            } else {
                row.error(testResults, e);
            }
        }
        catch (Exception e) {
            notCell.pass(testResults);
        }
    }

    public void show(Row row, TestResults testResults) throws Exception {
        try {
            CalledMethodTarget target = this.findMethodFromRow(row, 2);
            Object result = target.invoke(row.rowFrom(2), testResults, true);
            row.addCell(target.getResultString(result));
        }
        catch (IgnoredException ignoredException) {
            // empty catch block
        }
    }

    public void showDot(Row row, TestResults testResults) throws Exception {
        GraphicParser adapter = new GraphicParser(new NonGenericTyped(ObjectDotGraphic.class));
        try {
            Object result = this.callMethodInRow(row, testResults, true);
            row.addCell(adapter.show(new ObjectDotGraphic(result)));
        }
        catch (IgnoredException e) {
            // empty catch block
        }
    }

    public void ensure(Row row, TestResults testResults) throws Exception {
        this.expectedResult = new Boolean(true);
        try {
            Object result = this.callMethodInRow(row, testResults, true);
            row.cell(0).passOrFail(testResults, (Boolean)result);
        }
        catch (IgnoredException e) {
        }
        catch (Exception e) {
            row.cell(0).fail(testResults);
        }
    }

    public void note(Row row, TestResults testResults) throws Exception {
    }

    public CommentTraverse comment(Row row, TestResults testResults) throws Exception {
        return new CommentTraverse();
    }

    public CommentTraverse ignored(Row row, TestResults testResults) throws Exception {
        return new CommentTraverse(true);
    }

    public void start(Row row, TestResults testResults) throws Exception {
        String className = row.text(1);
        if (row.size() != 2) {
            throw new ExtraCellsException("DoTraverseStart");
        }
        try {
            this.setSystemUnderTest(ClassUtility.newInstance(className));
        }
        catch (Exception e) {
            throw new FitLibraryExceptionWithHelp("Unknown class: " + className, "UnknownClass.DoTraverseStart");
        }
    }

    public CalculateTraverse calculate(Row row, TestResults testResults) throws Exception {
        if (row.size() != 1) {
            throw new ExtraCellsException("DoTraverseCalculate");
        }
        CalculateTraverse traverse = this.getClass() == DoTraverse.class ? new CalculateTraverse(this.getTypedSystemUnderTest()) : new CalculateTraverse(this);
        traverse.theSetUpTearDownAlreadyHandled();
        return traverse;
    }

    public ConstraintTraverse constraint(Row row, TestResults testResults) throws Exception {
        if (row.size() != 1) {
            throw new ExtraCellsException("DoTraverseConstraint");
        }
        ConstraintTraverse traverse = new ConstraintTraverse(this);
        traverse.theSetUpTearDownAlreadyHandled();
        return traverse;
    }

    public ConstraintTraverse failingConstraint(Row row, TestResults testResults) throws Exception {
        if (row.size() != 1) {
            throw new ExtraCellsException("DoTraverseConstraint");
        }
        ConstraintTraverse traverse = new ConstraintTraverse(this, false);
        traverse.theSetUpTearDownAlreadyHandled();
        return traverse;
    }

    public UseTemplateTraverse useTemplate(Row row, TestResults testResults) throws Exception {
        return new UseTemplateTraverse(row.text(1));
    }

    public DefineTemplateTraverse template(Row row, TestResults testResults) throws Exception {
        return new DefineTemplateTraverse();
    }

    public void abandonStorytest(Row row, TestResults testResults) {
        this.flowControl.abandon();
    }

    public void setStopOnError(boolean stopOnError) {
        this.flowControl.setStopOnError(stopOnError);
    }

    public void expectedTestResults(Row row, TestResults testResults) throws Exception {
        if (testResults.matches(row.text(1), row.text(3), row.text(5), row.text(7))) {
            testResults.clear();
            row.cell(0).pass(testResults);
        } else {
            String results = testResults.toString();
            testResults.clear();
            row.cell(0).fail(testResults, results);
        }
    }

    public CalledMethodTarget findMethodFromRow(Row row, int less) throws Exception {
        return this.findMethodByActionName(row.rowFrom(1), row.size() - less);
    }

    public CalledMethodTarget findMethodByActionName(Row row, int allArgs) throws Exception {
        return LookupMethodTarget.findMethodInEverySecondCell(this, row, allArgs);
    }

    private Object callMethodInRow(Row row, TestResults testResults, boolean catchError) throws Exception {
        return this.findMethodFromRow(row, 2).invoke(row.rowFrom(2), testResults, catchError);
    }

    private CalledMethodTarget findSpecialMethod(String name) {
        return LookupMethodTarget.findSpecialMethod(this, name);
    }

    public void setGatherExpectedForGeneration(boolean gatherExpectedForGeneration) {
        this.gatherExpectedForGeneration = gatherExpectedForGeneration;
    }

    public void setExpectedResult(Object expectedResult) {
        this.expectedResult = expectedResult;
    }

    public Object getExpectedResult() {
        return this.expectedResult;
    }

    public static void checkForAmbiguity(String methodName, CalledMethodTarget specialMethod, MethodTarget target) {
        String methodDetails = "method " + methodName + "()";
        String parseMethodDetails = "method " + methodName + "(Row)";
        if (target != null && specialMethod != null) {
            throw new AmbiguousActionException(methodDetails, parseMethodDetails);
        }
    }

    public void setSetUpTraverse(CollectionSetUpTraverse setUpTraverse) {
        this.setUpTraverse = setUpTraverse;
        setUpTraverse.setOuterContext(this);
    }

    public void setSetUpTraverse(Object object) {
        this.setSetUpTraverse(new CollectionSetUpTraverse(object));
    }

    public void setSettingUp(boolean settingUp) {
        this.settingUp = settingUp;
    }

    public DoTraverse switchSetUp() {
        if (this.settingUp && this.setUpTraverse != null) {
            return this.setUpTraverse;
        }
        return this;
    }

    public void finishSettingUp() {
        this.setSettingUp(false);
    }

    public void doNotTearDownAutomatically() {
        this.canTearDown = false;
    }

    public void registerFlowControl(FlowControl flowControl) {
        this.flowControl = flowControl;
    }
}

