/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.typed;

import fitlibrary.parser.Parser;
import fitlibrary.parser.lookup.ParserSelector;
import fitlibrary.traverse.Evaluator;
import fitlibrary.typed.NonGenericTypedObject;
import fitlibrary.typed.Typed;
import fitlibrary.typed.TypedObject;
import fitlibrary.utility.ClassUtility;
import java.lang.reflect.InvocationTargetException;

public class NonGenericTyped
implements Typed {
    private Class classType;
    private boolean hasMethodOrField;
    private static ParserSelector parserSelector = new ParserSelector();

    public NonGenericTyped(Class classType) {
        this.classType = classType;
    }

    public NonGenericTyped(Class classType, boolean hasMethodOrField) {
        this(classType);
        this.hasMethodOrField = hasMethodOrField;
    }

    public Class asClass() {
        return this.classType;
    }

    public boolean hasMethodOrField() {
        return this.hasMethodOrField;
    }

    public Typed getComponentTyped() {
        return new NonGenericTyped(this.classType.getComponentType());
    }

    public boolean isPrimitive() {
        return this.classType.isPrimitive();
    }

    public boolean isArray() {
        return this.classType.isArray();
    }

    public boolean isGeneric() {
        return false;
    }

    public Object newInstance() throws InstantiationException, IllegalAccessException, SecurityException, IllegalArgumentException, NoSuchMethodException, InvocationTargetException {
        return ClassUtility.newInstance(this.asClass());
    }

    public String getClassName() {
        return this.asClass().getName();
    }

    public String simpleClassName() {
        return ClassUtility.simpleClassName(this.asClass());
    }

    public TypedObject typedObject(Object subject) {
        return new NonGenericTypedObject(subject);
    }

    public TypedObject newTypedInstance() throws InstantiationException, IllegalAccessException, SecurityException, IllegalArgumentException, NoSuchMethodException, InvocationTargetException {
        return this.typedObject(this.newInstance());
    }

    public Parser parser(Evaluator evaluator) {
        return parserSelector.parserFor(evaluator, this, false);
    }

    public Parser resultParser(Evaluator evaluator) {
        return parserSelector.parserFor(evaluator, this, true);
    }

    public Parser on(Evaluator evaluator, Typed typed, boolean isResult) {
        return parserSelector.parserFor(evaluator, typed, isResult);
    }

    public String toString() {
        return this.classType.toString();
    }
}

