/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.utility;

import fit.Counts;

public class TestResults {
    public static final String PASS_COLOUR = "#cfffcf";
    public static final String FAIL_COLOUR = "#ffcfcf";
    public static final String IGNORE_COLOR = "#efefef";
    public static final String ERROR_COLOUR = "#ffffcf";
    private Counts counts = new Counts();

    public TestResults(Counts counts) {
        this.counts = counts;
    }

    public TestResults() {
    }

    public void pass() {
        ++this.counts.right;
    }

    public void fail() {
        ++this.counts.wrong;
    }

    public void exception() {
        ++this.counts.exceptions;
    }

    public void ignore() {
        ++this.counts.ignores;
    }

    public void clear() {
        this.counts.right = 0;
        this.counts.wrong = 0;
        this.counts.ignores = 0;
        this.counts.exceptions = 0;
    }

    public void add(TestResults otherResults) {
        this.counts.tally(otherResults.counts);
    }

    public boolean passed() {
        return this.counts.right > 0 && this.counts.wrong == 0 & this.counts.exceptions == 0;
    }

    public boolean failed() {
        return this.counts.wrong > 0;
    }

    public boolean errors() {
        return this.counts.exceptions > 0;
    }

    public boolean problems() {
        return this.counts.wrong + this.counts.exceptions > 0;
    }

    public String toString() {
        return this.counts.toString();
    }

    public boolean matches(String rights, String wrongs, String ignores, String exceptions) {
        return this.cellValue(rights) == this.counts.right && this.cellValue(wrongs) == this.counts.wrong && this.cellValue(ignores) == this.counts.ignores && this.cellValue(exceptions) == this.counts.exceptions;
    }

    private int cellValue(String s) {
        return Integer.parseInt(s);
    }

    public Counts getCounts() {
        return this.counts;
    }

    public String asHtmlTable() {
        String colour = IGNORE_COLOR;
        if (this.passed()) {
            colour = PASS_COLOUR;
        } else if (this.problems()) {
            colour = this.counts.exceptions > 0 ? ERROR_COLOUR : FAIL_COLOUR;
        }
        return "<html><table><tr><td " + TestResults.backgroundColour(colour) + ">" + this.counts.toString() + "</td></tr></table><html>";
    }

    public static String replaceCss(String html) {
        String result = html;
        result = result.replaceAll("class=\"pass\"", TestResults.backgroundColour(PASS_COLOUR));
        result = result.replaceAll("class=\"fail\"", TestResults.backgroundColour(FAIL_COLOUR));
        result = result.replaceAll("class=\"ignore\"", TestResults.backgroundColour(IGNORE_COLOR));
        result = result.replaceAll("class=\"error\"", TestResults.backgroundColour(ERROR_COLOUR));
        return result;
    }

    private static String backgroundColour(String colour) {
        return "bgcolor=\"" + colour + "\"";
    }
}

