/*
 * Decompiled with CFR 0.152.
 */
package fitnesse;

import fit.Counts;
import fit.FitServer;
import fit.FitServerBridge;
import fit.FixtureListener;
import fit.Parse;
import fitnesse.components.CommandLine;
import fitnesse.runner.CachingResultFormatter;
import fitnesse.runner.FormattingOption;
import fitnesse.runner.PageResult;
import fitnesse.runner.ResultHandler;
import fitnesse.runner.StandardResultHandler;
import java.io.File;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public abstract class TestRunnerBridge {
    private String host;
    private int port;
    private String pageName;
    private FitServerBridge fitServer;
    public TestRunnerFixtureListener2 fixtureListener;
    public CachingResultFormatter handler;
    private PrintStream output;
    public List formatters = new LinkedList();
    private boolean debug;
    public boolean verbose;
    public boolean usingDownloadedPaths = true;

    public TestRunnerBridge() throws Exception {
        this(System.out);
    }

    public TestRunnerBridge(PrintStream output) throws Exception {
        this.output = output;
        this.handler = new CachingResultFormatter();
    }

    public void args(String[] args) throws Exception {
        CommandLine commandLine = new CommandLine("[-debug] [-v] [-results file] [-html file] [-xml file] [-nopath] host port pageName");
        if (!commandLine.parse(args)) {
            this.usage();
        }
        this.host = commandLine.getArgument("host");
        this.port = Integer.parseInt(commandLine.getArgument("port"));
        this.pageName = commandLine.getArgument("pageName");
        if (commandLine.hasOption("debug")) {
            this.debug = true;
        }
        if (commandLine.hasOption("v")) {
            this.verbose = true;
            this.handler.addHandler((ResultHandler)new StandardResultHandler(this.output));
        }
        if (commandLine.hasOption("nopath")) {
            this.usingDownloadedPaths = false;
        }
        if (commandLine.hasOption("results")) {
            this.formatters.add(new FormattingOption("raw", commandLine.getOptionArgument("results", "file"), (OutputStream)this.output, this.host, this.port, this.pageName));
        }
        if (commandLine.hasOption("html")) {
            this.formatters.add(new FormattingOption("html", commandLine.getOptionArgument("html", "file"), (OutputStream)this.output, this.host, this.port, this.pageName));
        }
        if (commandLine.hasOption("xml")) {
            this.formatters.add(new FormattingOption("xml", commandLine.getOptionArgument("xml", "file"), (OutputStream)this.output, this.host, this.port, this.pageName));
        }
    }

    protected void usage() {
        System.out.println("usage: java fitlibrary.suite.TestRunner [options] host port page-name");
        System.out.println("\t-v \tverbose: prints test progress to stdout");
        System.out.println("\t-results <filename|'stdout'>\tsave raw test results to a file or dump to standard output");
        System.out.println("\t-html <filename|'stdout'>\tformat results as HTML and save to a file or dump to standard output");
        System.out.println("\t-debug \tprints FitServer protocol actions to stdout");
        System.out.println("\t-nopath \tprevents downloaded path elements from being added to classpath");
        System.exit(-1);
    }

    public void run(String[] args) throws Exception {
        this.args(args);
        this.fitServer = this.createFitServer(this.host, this.port, this.debug);
        this.fixtureListener = new TestRunnerFixtureListener2(this);
        this.fitServer.fixtureListener = this.fixtureListener;
        this.fitServer.establishConnection(this.makeHttpRequest());
        this.fitServer.validateConnection();
        if (this.usingDownloadedPaths) {
            this.processClasspathDocument();
        }
        this.fitServer.process();
        this.finalCount();
        this.fitServer.closeConnection();
        this.fitServer.exit();
        this.doFormatting();
        this.handler.cleanUp();
    }

    protected abstract FitServerBridge createFitServer(String var1, int var2, boolean var3);

    private void processClasspathDocument() throws Exception {
        String classpathItems = this.fitServer.readDocument();
        if (this.verbose) {
            this.output.println("Adding to classpath: " + classpathItems);
        }
        TestRunnerBridge.addItemsToClasspath(classpathItems);
    }

    private void finalCount() throws Exception {
        this.handler.acceptFinalCount(this.fitServer.getCounts());
    }

    public int exitCode() {
        return this.fitServer == null ? -1 : this.fitServer.exitCode();
    }

    public String makeHttpRequest() {
        String request = "GET /" + this.pageName + "?responder=fitClient";
        if (this.usingDownloadedPaths) {
            request = request + "&includePaths=yes";
        }
        return request + " HTTP/1.1\r\n\r\n";
    }

    public Counts getCounts() {
        return this.fitServer.getCounts();
    }

    public void acceptResults(PageResult results) throws Exception {
        Counts counts = results.counts();
        this.fitServer.writeCounts(counts);
        this.handler.acceptResult(results);
    }

    public void doFormatting() throws Exception {
        Iterator iterator = this.formatters.iterator();
        while (iterator.hasNext()) {
            FormattingOption option = (FormattingOption)iterator.next();
            if (this.verbose) {
                this.output.println("Formatting as " + option.format + " to " + option.filename);
            }
            option.process(this.handler.getResultStream(), this.handler.getByteCount());
        }
    }

    public static void addItemsToClasspath(String classpathItems) throws Exception {
        String[] items = classpathItems.split(System.getProperty("path.separator"));
        for (int i = 0; i < items.length; ++i) {
            String item = items[i];
            TestRunnerBridge.addUrlToClasspath(new File(item).toURL());
        }
    }

    public static void addUrlToClasspath(URL u) throws Exception {
        URLClassLoader sysloader = (URLClassLoader)ClassLoader.getSystemClassLoader();
        Class sysclass = URLClassLoader.class;
        Method method = sysclass.getDeclaredMethod("addURL", URL.class);
        method.setAccessible(true);
        method.invoke((Object)sysloader, u);
    }

    public static class TestRunnerFixtureListener2
    implements FixtureListener {
        public Counts counts = new Counts();
        private boolean atStartOfResult = true;
        private PageResult currentPageResult;
        private TestRunnerBridge runner;

        public TestRunnerFixtureListener2(TestRunnerBridge runner) {
            this.runner = runner;
        }

        public void tableFinished(Parse table) {
            try {
                String data = new String(FitServer.readTable((Parse)table), "UTF-8");
                if (this.atStartOfResult) {
                    int indexOfFirstLineBreak = data.indexOf("\n");
                    String pageTitle = data.substring(0, indexOfFirstLineBreak);
                    data = data.substring(indexOfFirstLineBreak + 1);
                    this.currentPageResult = new PageResult(pageTitle);
                    this.atStartOfResult = false;
                }
                this.currentPageResult.append(data);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public void tablesFinished(Counts count) {
            try {
                this.currentPageResult.setCounts(count);
                this.runner.acceptResults(this.currentPageResult);
                this.atStartOfResult = true;
                this.counts.tally(count);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

