/*
 * Decompiled with CFR 0.152.
 */
package test.fitlibrary;

import fit.Parse;
import fitlibrary.runner.CustomRunner;
import fitlibrary.runner.CustomRunnerException;
import fitlibrary.utility.ParseUtility;
import junit.framework.TestCase;

public class TestMakeParse
extends TestCase {
    private static final String HEADER = "<html><head><title>test</title></head><body>\n";
    private static final String FOOTER = "</body></html>\n";
    private CustomRunner runner;

    public void setUp() {
        this.runner = new CustomRunner("test");
    }

    public void testNoTableForRow() {
        try {
            this.runner.addRow("a");
            TestMakeParse.fail((String)"No exception thrown");
        }
        catch (CustomRunnerException customRunnerException) {
            // empty catch block
        }
    }

    public void testNoTables() {
        try {
            this.runner.getTables();
            TestMakeParse.fail((String)"No exception thrown");
        }
        catch (CustomRunnerException customRunnerException) {
            // empty catch block
        }
    }

    public void testOneRow() {
        this.runner.addTable("a");
        this.assertBody("<table border cellspacing=0 cellpadding=3>\n<tr>\n<td>a</td></tr></table>\n");
    }

    public void testOneRowInItalics() {
        this.runner.addTable("<i>a</i>");
        this.assertBody("<table border cellspacing=0 cellpadding=3>\n<tr>\n<td><i>a</i></td></tr></table>\n");
    }

    public void testLeader() {
        this.runner.addTableWithLeaderText("a", "leader<br>\n");
        this.assertBody("leader<br>\n<table border cellspacing=0 cellpadding=3>\n<tr>\n<td>a</td></tr></table>\n");
    }

    public void testTrailer() {
        this.runner.addTable("a");
        this.runner.addTableTrailer("trailer");
        this.assertBody("<table border cellspacing=0 cellpadding=3>\n<tr>\n<td>a</td></tr></table>trailer\n");
    }

    public void testMiddleTrailerNotLost() {
        this.runner.addTable("a");
        this.runner.addTableTrailer("TRAILER");
        this.runner.addTable("b");
        this.assertBody("<table border cellspacing=0 cellpadding=3>\n<tr>\n<td>a</td></tr></table>TRAILER\n<br><table border cellspacing=0 cellpadding=3>\n<tr>\n<td>b</td></tr></table>\n");
    }

    public void testTwoMiddleTrailers() {
        this.runner.addTable("a");
        this.runner.addTableTrailer("TRAILER");
        this.runner.addTableTrailer("222");
        this.runner.addTable("b");
        this.assertBody("<table border cellspacing=0 cellpadding=3>\n<tr>\n<td>a</td></tr></table>TRAILER<br>222\n<br><table border cellspacing=0 cellpadding=3>\n<tr>\n<td>b</td></tr></table>\n");
    }

    public void testTwoRows() {
        this.runner.addTable("a");
        this.runner.addRow("b|c");
        this.assertBody("<table border cellspacing=0 cellpadding=3>\n<tr>\n<td ColSpan=2>a</td></tr>\n<tr>\n<td>b</td>\n<td>c</td></tr></table>\n");
    }

    public void testThreeRows() {
        this.runner.addTable("z|a");
        this.runner.addRow("b|c|d");
        this.runner.addRow("b|c");
        this.assertBody("<table border cellspacing=0 cellpadding=3>\n<tr>\n<td>z</td>\n<td ColSpan=2>a</td></tr>\n<tr>\n<td>b</td>\n<td>c</td>\n<td>d</td></tr>\n<tr>\n<td>b</td>\n<td ColSpan=2>c</td></tr></table>\n");
    }

    public void testTwoTables() {
        this.runner.addTable("a");
        this.runner.addRow("b|c|d");
        this.runner.addTable("fit.Summary");
        this.assertBody("<table border cellspacing=0 cellpadding=3>\n<tr>\n<td ColSpan=3>a</td></tr>\n<tr>\n<td>b</td>\n<td>c</td>\n<td>d</td></tr></table>\n<br><table border cellspacing=0 cellpadding=3>\n<tr>\n<td>fit.Summary</td></tr></table>\n");
    }

    public void testParse() {
        this.runner.addTable("a");
        this.runner.addRow("b|c");
        Parse segment = this.runner.getTables();
        String body = "<table border cellspacing=0 cellpadding=3>\n<tr>\n<td ColSpan=2>a</td></tr>\n<tr>\n<td>b</td>\n<td>c</td></tr></table>\n";
        TestMakeParse.assertEquals((String)(HEADER + body + FOOTER), (String)ParseUtility.toString(segment));
    }

    public void testSplicingJustSegments() {
        this.runner.addTables(this.makeSegments());
        this.assertBody("<table border cellspacing=0 cellpadding=3>\n<tr>\n<td>SEGMENT</td></tr></table>\n<br><table border cellspacing=0 cellpadding=3>\n<tr>\n<td>END</td></tr></table>\n");
    }

    public void testTrailerOnSplicedTable() {
        this.runner.addTables(this.makeSegments());
        this.runner.addTableTrailer("TRAILER");
        this.assertBody("<table border cellspacing=0 cellpadding=3>\n<tr>\n<td>SEGMENT</td></tr></table>\n<br><table border cellspacing=0 cellpadding=3>\n<tr>\n<td>END</td></tr></table>\n<br>TRAILER");
    }

    public void testSplicingOfSegments() {
        this.runner.addTable("AAAA");
        this.runner.addTables(this.makeSegments());
        this.runner.addTable("BBBB");
        this.assertBody("<table border cellspacing=0 cellpadding=3>\n<tr>\n<td>AAAA</td></tr></table>\n<table border cellspacing=0 cellpadding=3>\n<tr>\n<td>SEGMENT</td></tr></table>\n<br><table border cellspacing=0 cellpadding=3>\n<tr>\n<td>END</td></tr></table>\n\n<br><table border cellspacing=0 cellpadding=3>\n<tr>\n<td>BBBB</td></tr></table>\n");
    }

    public void testSplice() {
        String spliceBody = "<html><head><title>segment</title></head><body>\n<table border cellspacing=0 cellpadding=3>\n<tr>\n<td>SEGMENT</td></tr></table>\n<br><table border cellspacing=0 cellpadding=3>\n<tr>\n<td>END</td></tr></table>\n</body></html>\n";
        this.assertEquals("<html><head><title>segment</title></head><body>\n<table border cellspacing=0 cellpadding=3>\n<tr>\n<td>SEGMENT</td></tr></table>\n<br><table border cellspacing=0 cellpadding=3>\n<tr>\n<td>END</td></tr></table>\n</body></html>\n", this.makeSegments());
    }

    private Parse makeSegments() {
        CustomRunner segmentRunner = new CustomRunner("segment");
        segmentRunner.addTable("SEGMENT");
        segmentRunner.addTable("END");
        Parse tables = segmentRunner.getTables();
        return tables;
    }

    private void assertBody(String body) {
        TestMakeParse.assertEquals((String)(HEADER + body + FOOTER), (String)this.runner.toString());
    }

    private void assertEquals(String expected, Parse table) {
        TestMakeParse.assertEquals((String)expected, (String)ParseUtility.toString(table));
    }
}

