/*
 * Decompiled with CFR 0.152.
 */
package test.fitlibrary.parser;

import fitlibrary.DoFixture;
import fitlibrary.parser.Parser;
import fitlibrary.parser.lookup.ResultParser;
import fitlibrary.table.Cell;
import fitlibrary.traverse.Traverse;
import fitlibrary.utility.TestResults;
import java.lang.reflect.Method;
import junit.framework.TestCase;

public class TestArrayParser
extends TestCase {
    public int[] aProp = new int[]{5, 6, 7};

    public void testAdapterAlone() throws Exception {
        int[] ints = new int[]{1, 2, 3};
        Parser parser = Traverse.asTyped(ints).parser(new DoFixture());
        String cellText = "1, 2, 3";
        Cell cell = new Cell(cellText);
        int[] expectedResult = new int[]{1, 2, 3};
        this.assertArrayEquals(expectedResult, (int[])parser.parseTyped(cell, new TestResults()).getSubject());
        TestArrayParser.assertTrue((boolean)parser.matches(cell, expectedResult, new TestResults()));
        TestArrayParser.assertEquals((String)cellText, (String)parser.show(expectedResult));
    }

    private void assertArrayEquals(int[] expectedResult, int[] actual) {
        TestArrayParser.assertEquals((int)expectedResult.length, (int)actual.length);
        for (int i = 0; i < actual.length; ++i) {
            TestArrayParser.assertEquals((String)("Element #" + i), (int)expectedResult[i], (int)actual[i]);
        }
    }

    public void testAdapterWithMethod() throws Exception {
        int[] ints = new int[]{4, 5, 6};
        Method method = ((Object)((Object)this)).getClass().getMethod("aMethod", new Class[0]);
        ResultParser adapter = Traverse.asTypedObject((Object)this).resultParser(null, method);
        adapter.setTarget((Object)this);
        Object actual = adapter.getResult();
        TestArrayParser.assertEquals(ints.getClass(), actual.getClass());
        this.assertArrayEquals(ints, (int[])actual);
        TestArrayParser.assertEquals((String)"4, 5, 6", (String)adapter.show(adapter.getResult()));
    }

    public int[] aMethod() {
        return new int[]{4, 5, 6};
    }

    public void testAdapterWithProperty() throws Exception {
        int[] ints = new int[]{5, 6, 7};
        Parser adapter = Traverse.asTyped(ints).parser(new DoFixture());
        TestArrayParser.assertEquals((String)"5, 6, 7", (String)adapter.show(ints));
        Object parse = adapter.parseTyped(new Cell("5,6,7"), new TestResults()).getSubject();
        int[] results = (int[])parse;
        this.assertArrayEquals(results, ints);
    }
}

