/*
 * Decompiled with CFR 0.152.
 */
package test.fitlibrary.parser;

import fitlibrary.DoFixture;
import fitlibrary.parser.Parser;
import fitlibrary.parser.lookup.ResultParser;
import fitlibrary.table.Cell;
import fitlibrary.traverse.Traverse;
import fitlibrary.utility.TestResults;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import junit.framework.TestCase;

public class TestCollectionParser
extends TestCase {
    Collection list;
    public Collection aProp;

    public void setUp() {
        this.list = new ArrayList();
        this.list.add("1");
        this.list.add("2");
        this.list.add("3");
        this.aProp = new ArrayList();
        this.aProp.add("4");
        this.aProp.add("5");
        this.aProp.add("6");
    }

    public void testParserAlone() throws Exception {
        Parser parser = Traverse.asTyped(this.list).parser(new DoFixture());
        String cellText = "1, 2, 3";
        Cell cell = new Cell(cellText);
        TestCollectionParser.assertEquals((Object)this.list, (Object)parser.parseTyped(cell, new TestResults()).getSubject());
        TestCollectionParser.assertTrue((boolean)parser.matches(cell, this.list, new TestResults()));
        TestCollectionParser.assertEquals((String)cellText, (String)parser.show(this.list));
    }

    public void testParserWithMethod() throws Exception {
        Method method = ((Object)((Object)this)).getClass().getMethod("aMethod", new Class[0]);
        ResultParser adapter = Traverse.asTypedObject((Object)this).resultParser(null, method);
        adapter.setTarget((Object)this);
        TestCollectionParser.assertEquals((Object)this.aProp, (Object)adapter.getResult());
        TestCollectionParser.assertEquals((String)"4, 5, 6", (String)adapter.show(adapter.getResult()));
    }

    public Collection aMethod() {
        return this.aProp;
    }
}

