/*
 * Decompiled with CFR 0.152.
 */
package fit;

import fit.Fixture;
import fit.Parse;
import fit.TypeAdapter;
import fit.exception.CouldNotParseFitFailureException;
import fit.exception.FitFailureException;
import fit.exception.NoSuchMethodFitFailureException;
import java.lang.reflect.Method;

public class ActionFixture
extends Fixture {
    protected Parse cells;
    private Fixture actor;

    @Override
    public void doCells(Parse cells) {
        this.cells = cells;
        String methodName = cells.text();
        try {
            this.getClass().getMethod(methodName, new Class[0]).invoke((Object)this, new Object[0]);
        }
        catch (Exception e) {
            this.exception(cells, e);
        }
    }

    public void start() throws Throwable {
        Parse fixture = this.cells.more;
        if (this.isNullOrBlank(fixture)) {
            throw new FitFailureException("You must specify a fixture to start.");
        }
        this.actor = ActionFixture.loadFixture(fixture.text());
    }

    private boolean isNullOrBlank(Parse fixture) {
        return fixture == null || fixture.text().equals("");
    }

    public Fixture getActor() {
        return this.actor;
    }

    public void enter() throws Exception {
        Parse argumentCell = this.cells.more.more;
        if (argumentCell == null) {
            throw new FitFailureException("You must specify an argument.");
        }
        Method enterMethod = this.tryFindMethodWithArgs(1);
        Class<?> parameterType = enterMethod.getParameterTypes()[0];
        String argument = argumentCell.text();
        enterMethod.invoke((Object)this.actor, this.adaptArgumentToType(parameterType, argument));
    }

    private Object adaptArgumentToType(Class<?> parameterType, String argument) throws Exception {
        Object arg;
        try {
            arg = TypeAdapter.on(this.actor, parameterType).parse(argument);
        }
        catch (NumberFormatException e) {
            throw new CouldNotParseFitFailureException(argument, parameterType.getName());
        }
        return arg;
    }

    public void press() throws Exception {
        this.tryFindMethodWithArgs(0).invoke((Object)this.actor, new Object[0]);
    }

    public void check() throws Throwable {
        Method checkMethod = this.tryFindMethodWithArgs(0);
        Class<?> returnType = checkMethod.getReturnType();
        Parse checkValueCell = this.cells.more.more;
        if (checkValueCell == null) {
            throw new FitFailureException("You must specify a value to check.");
        }
        this.check(checkValueCell, this.getTypeAdapter(checkMethod, returnType));
    }

    private TypeAdapter getTypeAdapter(Method checkMethod, Class<?> returnType) {
        try {
            return TypeAdapter.on(this.actor, checkMethod);
        }
        catch (Throwable e) {
            throw new FitFailureException("Can not parse return type: " + returnType.getName());
        }
    }

    protected Method tryFindMethodWithArgs(int args) throws NoSuchMethodException {
        Parse methodCell = this.cells.more;
        if (this.isNullOrBlank(methodCell)) {
            throw new FitFailureException("You must specify a method.");
        }
        String methodName = ActionFixture.camel(methodCell.text());
        if (this.actor == null) {
            throw new FitFailureException("You must start a fixture using the 'start' keyword.");
        }
        Method theMethod = this.findMethodWithArgs(methodName, args);
        if (theMethod == null) {
            throw new NoSuchMethodFitFailureException(methodName);
        }
        return theMethod;
    }

    private Method findMethodWithArgs(String methodName, int args) {
        Method[] methods = this.actor.getClass().getMethods();
        Method theMethod = null;
        for (Method m : methods) {
            if (!m.getName().equals(methodName) || m.getParameterTypes().length != args) continue;
            if (theMethod == null) {
                theMethod = m;
                continue;
            }
            throw new FitFailureException("You can only have one " + methodName + "(arg) method in your fixture.");
        }
        return theMethod;
    }
}

