/*
 * Decompiled with CFR 0.152.
 */
package fit;

import fit.Fixture;
import fit.Parse;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Date;

public class FileRunner {
    public String input;
    public Parse tables;
    public Fixture fixture = new Fixture();
    public PrintWriter output;

    public static void main(String[] argv) {
        new FileRunner().run(argv);
    }

    public void run(String[] argv) {
        this.args(argv);
        this.process();
        this.exit();
    }

    public void process() {
        try {
            this.tables = new Parse(this.input);
            this.fixture.doTables(this.tables);
        }
        catch (Exception e) {
            this.exception(e);
        }
        this.tables.print(this.output);
    }

    public void args(String[] argv) {
        if (argv.length != 2) {
            System.err.println("usage: java fit.FileRunner input-file output-file");
            System.exit(-1);
        }
        File in = new File(argv[0]);
        File out = new File(argv[1]);
        this.fixture.summary.put("input file", in.getAbsolutePath());
        this.fixture.summary.put("input update", new Date(in.lastModified()));
        this.fixture.summary.put("output file", out.getAbsolutePath());
        try {
            this.input = this.read(in);
            this.output = new PrintWriter(new BufferedWriter(new FileWriter(out)));
        }
        catch (IOException e) {
            System.err.println(e.getMessage());
            System.exit(-1);
        }
    }

    protected String read(File input) throws IOException {
        char[] chars = new char[(int)input.length()];
        try (FileReader in = new FileReader(input);){
            in.read(chars);
        }
        return new String(chars);
    }

    protected void exception(Exception e) {
        this.tables = new Parse("body", "Unable to parse input. Input ignored.", null, null);
        this.fixture.exception(this.tables, e);
    }

    protected void exit() {
        this.output.close();
        System.err.println(this.fixture.counts());
        System.exit(this.fixture.counts.wrong + this.fixture.counts.exceptions);
    }
}

