/*
 * Decompiled with CFR 0.152.
 */
package fit;

import fit.Counts;
import java.io.IOException;
import java.io.OutputStream;
import java.text.DecimalFormat;
import util.FileUtil;
import util.StreamReader;

public class FitProtocol {
    public static final DecimalFormat format = new DecimalFormat("0000000000");

    public static void writeData(String data, OutputStream output) throws IOException {
        byte[] bytes = data.getBytes(FileUtil.CHARENCODING);
        FitProtocol.writeData(bytes, output);
    }

    public static void writeData(byte[] bytes, OutputStream output) throws IOException {
        int length = bytes.length;
        FitProtocol.writeSize(length, output);
        output.write(bytes);
        output.flush();
    }

    public static void writeSize(int length, OutputStream output) throws IOException {
        String formattedLength = format.format(length);
        byte[] lengthBytes = formattedLength.getBytes();
        output.write(lengthBytes);
        output.flush();
    }

    public static void writeCounts(Counts count, OutputStream output) throws IOException {
        FitProtocol.writeSize(0, output);
        FitProtocol.writeSize(count.right, output);
        FitProtocol.writeSize(count.wrong, output);
        FitProtocol.writeSize(count.ignores, output);
        FitProtocol.writeSize(count.exceptions, output);
    }

    public static int readSize(StreamReader reader) throws IOException {
        String sizeString = reader.read(10);
        if (sizeString.length() < 10) {
            throw new IOException("A size value could not be read. Fragment=|" + sizeString + "|");
        }
        return Integer.valueOf(sizeString);
    }

    public static String readDocument(StreamReader reader, int size) throws IOException {
        return reader.read(size);
    }

    public static Counts readCounts(StreamReader reader) throws IOException {
        Counts counts = new Counts();
        counts.right = FitProtocol.readSize(reader);
        counts.wrong = FitProtocol.readSize(reader);
        counts.ignores = FitProtocol.readSize(reader);
        counts.exceptions = FitProtocol.readSize(reader);
        return counts;
    }
}

