/*
 * Decompiled with CFR 0.152.
 */
package fitnesse;

import fitnesse.ConfigurationParameter;
import fitnesse.FitNesseContext;
import fitnesse.FitNesseVersion;
import fitnesse.authentication.Authenticator;
import fitnesse.components.ComponentFactory;
import fitnesse.components.Logger;
import fitnesse.plugins.PluginException;
import fitnesse.plugins.PluginsLoader;
import fitnesse.reporting.FormatterFactory;
import fitnesse.responders.editing.ContentFilter;
import fitnesse.responders.editing.ContentFilterResponder;
import fitnesse.testrunner.MultipleTestSystemFactory;
import fitnesse.testsystems.TestSystemListener;
import fitnesse.testsystems.slim.CustomComparatorRegistry;
import fitnesse.testsystems.slim.tables.SlimTableFactory;
import fitnesse.util.ClassUtils;
import fitnesse.wiki.RecentChanges;
import fitnesse.wiki.RecentChangesWikiPage;
import fitnesse.wiki.SystemVariableSource;
import fitnesse.wiki.WikiPageFactory;
import fitnesse.wiki.WikiPageFactoryRegistry;
import fitnesse.wiki.fs.FileSystemPageFactory;
import fitnesse.wiki.fs.VersionsController;
import fitnesse.wiki.fs.ZipFileVersionsController;
import fitnesse.wikitext.parser.SymbolProvider;
import fitnesse.wikitext.parser.decorator.SlimTableDefaultColoring;
import java.io.IOException;
import java.util.Properties;

public class ContextConfigurator {
    private static final java.util.logging.Logger LOG = java.util.logging.Logger.getLogger(ContextConfigurator.class.getName());
    private static final String DEFAULT_PATH = ".";
    public static final String DEFAULT_ROOT = "FitNesseRoot";
    public static final String DEFAULT_CONTEXT_ROOT = "/";
    private static final int DEFAULT_VERSION_DAYS = 14;
    private static final int DEFAULT_COMMAND_PORT = 9123;
    public static final int DEFAULT_PORT = 80;
    public static final String DEFAULT_CONFIG_FILE = "plugins.properties";
    public static final String DEFAULT_THEME = "bootstrap";
    private WikiPageFactory wikiPageFactory;
    private Integer port;
    private String rootPath = ".";
    private String rootDirectoryName = "FitNesseRoot";
    private String contextRoot;
    private Logger logger;
    private Authenticator authenticator;
    private VersionsController versionsController;
    private RecentChanges recentChanges;
    private final Properties properties = new Properties();
    private TestSystemListener testSystemListener;
    private ClassLoader classLoader;

    private ContextConfigurator() {
    }

    public static ContextConfigurator empty() {
        return new ContextConfigurator();
    }

    public static ContextConfigurator systemDefaults() {
        return ContextConfigurator.empty().withRootPath(DEFAULT_PATH).withClassLoader(ClassUtils.getClassLoader()).withParameter(ConfigurationParameter.ROOT_DIRECTORY, DEFAULT_ROOT).withParameter(ConfigurationParameter.CONTEXT_ROOT, DEFAULT_CONTEXT_ROOT).withParameter(ConfigurationParameter.VERSIONS_CONTROLLER_DAYS, Integer.toString(14)).withParameter(ConfigurationParameter.CONFIG_FILE, DEFAULT_CONFIG_FILE);
    }

    public ContextConfigurator updatedWith(Properties newProperties) {
        for (String key : newProperties.stringPropertyNames()) {
            this.withParameter(key, newProperties.getProperty(key));
        }
        return this;
    }

    public ContextConfigurator withTestSystemListener(TestSystemListener testSystemListener) {
        this.testSystemListener = testSystemListener;
        return this;
    }

    public FitNesseContext makeFitNesseContext() throws IOException, PluginException {
        SystemVariableSource variableSource;
        String theme;
        ClassUtils.setClassLoader(this.classLoader);
        Thread.currentThread().setContextClassLoader(this.classLoader);
        ComponentFactory componentFactory = new ComponentFactory(this.properties, this.classLoader);
        if (this.port == null) {
            this.port = this.getPort();
        }
        FitNesseVersion version = new FitNesseVersion();
        this.updateFitNesseProperties(version);
        if (this.wikiPageFactory == null) {
            this.wikiPageFactory = componentFactory.createComponent(ConfigurationParameter.WIKI_PAGE_FACTORY_CLASS, FileSystemPageFactory.class);
        }
        if (this.versionsController == null) {
            this.versionsController = componentFactory.createComponent(ConfigurationParameter.VERSIONS_CONTROLLER_CLASS, ZipFileVersionsController.class);
        }
        if (this.recentChanges == null) {
            this.recentChanges = componentFactory.createComponent(ConfigurationParameter.RECENT_CHANGES_CLASS, RecentChangesWikiPage.class);
        }
        PluginsLoader pluginsLoader = new PluginsLoader(componentFactory, this.classLoader);
        if (this.logger == null) {
            this.logger = pluginsLoader.makeLogger(this.get(ConfigurationParameter.LOG_DIRECTORY));
        }
        if (this.authenticator == null) {
            this.authenticator = pluginsLoader.makeAuthenticator(this.get(ConfigurationParameter.CREDENTIALS));
        }
        if ((theme = (variableSource = new SystemVariableSource(this.properties)).getProperty(ConfigurationParameter.THEME.getKey())) == null && (theme = pluginsLoader.getDefaultTheme()) == null) {
            theme = DEFAULT_THEME;
        }
        SlimTableFactory slimTableFactory = new SlimTableFactory();
        CustomComparatorRegistry customComparatorRegistry = new CustomComparatorRegistry();
        MultipleTestSystemFactory testSystemFactory = new MultipleTestSystemFactory(slimTableFactory, customComparatorRegistry, this.classLoader);
        FormatterFactory formatterFactory = new FormatterFactory(componentFactory);
        FitNesseContext context = new FitNesseContext(version, this.wikiPageFactory, this.rootPath, this.rootDirectoryName, this.contextRoot, this.versionsController, this.recentChanges, this.port, this.authenticator, this.logger, testSystemFactory, this.testSystemListener, formatterFactory, this.properties, variableSource, theme);
        SymbolProvider wikiParsingProvider = SymbolProvider.wikiParsingProvider;
        SymbolProvider noLinksTableParsingProvider = SymbolProvider.noLinksTableParsingProvider;
        SlimTableDefaultColoring.createInstanceIfNeeded(slimTableFactory);
        SlimTableDefaultColoring.install();
        pluginsLoader.loadResponders(context.responderFactory);
        if (this.wikiPageFactory instanceof WikiPageFactoryRegistry) {
            pluginsLoader.loadWikiPageFactories((WikiPageFactoryRegistry)((Object)this.wikiPageFactory));
        } else {
            LOG.warning("Wiki page factory does not implement interface WikiPageFactoryRegistrar, configured factories can not be loaded.");
        }
        pluginsLoader.loadTestSystems(testSystemFactory);
        pluginsLoader.loadFormatters(formatterFactory);
        pluginsLoader.loadSymbolTypes(wikiParsingProvider);
        pluginsLoader.loadSymbolTypes(noLinksTableParsingProvider);
        pluginsLoader.loadSlimTables(slimTableFactory);
        pluginsLoader.loadCustomComparators(customComparatorRegistry);
        pluginsLoader.loadTestRunFactories(context.testRunFactoryRegistry);
        ContentFilter contentFilter = pluginsLoader.loadContentFilter();
        if (contentFilter != null) {
            context.responderFactory.addFilter("save", new ContentFilterResponder(contentFilter));
        }
        return context;
    }

    private void updateFitNesseProperties(FitNesseVersion version) {
        if (this.rootPath != null) {
            this.properties.setProperty("FITNESSE_ROOTPATH", this.rootPath);
        }
        this.properties.setProperty("FITNESSE_PORT", Integer.toString(this.port));
        this.properties.setProperty("FITNESSE_VERSION", version.toString());
        for (ConfigurationParameter parameter : ConfigurationParameter.values()) {
            String value = this.get(parameter);
            if (value == null) continue;
            this.properties.setProperty(parameter.getKey(), value);
        }
    }

    private int getPort() {
        if (this.port == null) {
            if (this.get(ConfigurationParameter.COMMAND) != null) {
                return 9123;
            }
            return 80;
        }
        return this.port;
    }

    public ContextConfigurator withRootPath(String rootPath) {
        this.rootPath = rootPath;
        return this;
    }

    public ContextConfigurator withParameter(String key, String value) {
        ConfigurationParameter parameter = ConfigurationParameter.byKey(key);
        if (parameter == null) {
            this.properties.put(key, value);
        } else {
            this.withParameter(parameter, value);
        }
        return this;
    }

    public ContextConfigurator withParameter(ConfigurationParameter parameter, String value) {
        switch (parameter) {
            case ROOT_PATH: {
                this.rootPath = value;
                break;
            }
            case ROOT_DIRECTORY: {
                this.rootDirectoryName = value;
                break;
            }
            case CONTEXT_ROOT: {
                this.contextRoot = value;
                if (!this.contextRoot.startsWith(DEFAULT_CONTEXT_ROOT)) {
                    this.contextRoot = DEFAULT_CONTEXT_ROOT + this.contextRoot;
                }
                if (this.contextRoot.endsWith(DEFAULT_CONTEXT_ROOT)) break;
                this.contextRoot = this.contextRoot + DEFAULT_CONTEXT_ROOT;
                break;
            }
            case PORT: {
                this.port = Integer.parseInt(value);
                break;
            }
            default: {
                this.properties.setProperty(parameter.getKey(), value);
            }
        }
        return this;
    }

    public ContextConfigurator withRootDirectoryName(String rootDirectoryName) {
        this.rootDirectoryName = rootDirectoryName;
        return this;
    }

    public ContextConfigurator withWikiPageFactory(WikiPageFactory wikiPageFactory) {
        this.wikiPageFactory = wikiPageFactory;
        return this;
    }

    public ContextConfigurator withPort(int port) {
        this.port = port;
        return this;
    }

    public ContextConfigurator withAuthenticator(Authenticator authenticator) {
        this.authenticator = authenticator;
        return this;
    }

    public ContextConfigurator withVersionsController(VersionsController versionsController) {
        this.versionsController = versionsController;
        return this;
    }

    public ContextConfigurator withRecentChanges(RecentChanges recentChanges) {
        this.recentChanges = recentChanges;
        return this;
    }

    public ContextConfigurator withClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
        return this;
    }

    public String get(ConfigurationParameter parameter) {
        switch (parameter) {
            case ROOT_PATH: {
                return this.rootPath;
            }
            case ROOT_DIRECTORY: {
                return this.rootDirectoryName;
            }
            case CONTEXT_ROOT: {
                return this.contextRoot;
            }
            case PORT: {
                return String.valueOf(this.port);
            }
        }
        return this.properties.getProperty(parameter.getKey());
    }
}

