/*
 * Decompiled with CFR 0.152.
 */
package fitnesse;

import fitnesse.FitNesseContext;
import fitnesse.FitNesseExpediter;
import fitnesse.FitNesseServer;
import fitnesse.http.MockRequestBuilder;
import fitnesse.http.MockResponseSender;
import fitnesse.http.Request;
import fitnesse.http.Response;
import fitnesse.socketservice.SocketService;
import fitnesse.util.MockSocket;
import fitnesse.util.SerialExecutorService;
import java.io.IOException;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FitNesse {
    private static final Logger LOG = Logger.getLogger(FitNesse.class.getName());
    private final FitNesseContext context;
    private final ExecutorService executorService;
    private volatile SocketService theService;

    public FitNesse(FitNesseContext context) {
        this.context = context;
        RejectedExecutionHandler rejectionHandler = new RejectedExecutionHandler(){

            @Override
            public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
                LOG.log(Level.WARNING, "Could not handle request. Thread pool is exhausted.");
            }
        };
        this.executorService = new ThreadPoolExecutor(5, 100, 10L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), new DaemonThreadFactory(), rejectionHandler);
    }

    public void start(ServerSocket serverSocket) throws IOException {
        this.theService = new SocketService(new FitNesseServer(this.context, this.executorService), false, serverSocket);
    }

    public synchronized void stop() throws IOException {
        if (this.theService != null) {
            this.theService.close();
            this.theService = null;
        }
        if (!this.executorService.isShutdown()) {
            this.executorService.shutdown();
        }
    }

    public boolean isRunning() {
        return this.theService != null;
    }

    public void executeSingleCommand(String command, OutputStream out) throws Exception {
        FitNesseExpediter expediter = new FitNesseExpediter(new MockSocket(), this.context, new SerialExecutorService());
        Request request = new MockRequestBuilder(command).noChunk().build();
        Response response = expediter.createGoodResponse(request);
        int responseStatus = response.getStatus();
        if (responseStatus >= 400 && responseStatus <= 599) {
            throw new Exception("error loading page: " + responseStatus);
        }
        response.withoutHttpHeaders();
        MockResponseSender sender = new MockResponseSender(out);
        sender.doSending(response);
    }

    static class DaemonThreadFactory
    implements ThreadFactory {
        private final ThreadGroup group;
        private final AtomicInteger threadNumber = new AtomicInteger(1);
        private final String namePrefix;

        DaemonThreadFactory() {
            SecurityManager s = System.getSecurityManager();
            this.group = s != null ? s.getThreadGroup() : Thread.currentThread().getThreadGroup();
            this.namePrefix = "server-thread-";
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(this.group, r, this.namePrefix + this.threadNumber.getAndIncrement(), 0L);
            t.setDaemon(true);
            if (t.getPriority() != 5) {
                t.setPriority(5);
            }
            return t;
        }
    }
}

