/*
 * Decompiled with CFR 0.152.
 */
package fitnesse;

import fitnesse.FitNesse;
import fitnesse.FitNesseVersion;
import fitnesse.authentication.Authenticator;
import fitnesse.components.Logger;
import fitnesse.html.template.PageFactory;
import fitnesse.reporting.FormatterFactory;
import fitnesse.responders.ResponderFactory;
import fitnesse.testrunner.run.FileBasedTestRunFactory;
import fitnesse.testrunner.run.TestRunFactoryRegistry;
import fitnesse.testsystems.TestSystemFactory;
import fitnesse.testsystems.TestSystemListener;
import fitnesse.util.StringUtils;
import fitnesse.wiki.RecentChanges;
import fitnesse.wiki.SystemVariableSource;
import fitnesse.wiki.UrlPathVariableSource;
import fitnesse.wiki.WikiPage;
import fitnesse.wiki.WikiPageFactory;
import fitnesse.wiki.fs.VersionsController;
import fitnesse.wikitext.VariableSource;
import java.io.File;
import java.util.Map;
import java.util.Properties;

public class FitNesseContext {
    public static final String WIKI_PROTOCOL_PROPERTY = "wiki.protocol";
    public static final String SSL_PARAMETER_CLASS_PROPERTY = "wiki.protocol.ssl.parameter.class";
    public static final String SSL_CLIENT_AUTH_PROPERTY = "wiki.protocol.ssl.client.auth";
    public static final String recentChangesDateFormat = "kk:mm:ss EEE, MMM dd, yyyy";
    public static final String rfcCompliantDateFormat = "EEE, d MMM yyyy HH:mm:ss Z";
    public static final String testResultsDirectoryName = "testResults";
    public final FitNesseVersion version;
    public final FitNesse fitNesse;
    public final TestSystemFactory testSystemFactory;
    public final TestSystemListener testSystemListener;
    public final TestRunFactoryRegistry testRunFactoryRegistry;
    public final FormatterFactory formatterFactory;
    public final int port;
    private final WikiPageFactory wikiPageFactory;
    public final String rootPath;
    private final String rootDirectoryName;
    public final String contextRoot;
    public final ResponderFactory responderFactory;
    public final String theme;
    public final PageFactory pageFactory;
    public final SystemVariableSource variableSource;
    public final VersionsController versionsController;
    public final RecentChanges recentChanges;
    public final Logger logger;
    public final Authenticator authenticator;
    private final Properties properties;

    protected FitNesseContext(FitNesseVersion version, WikiPageFactory wikiPageFactory, String rootPath, String rootDirectoryName, String contextRoot, VersionsController versionsController, RecentChanges recentChanges, int port, Authenticator authenticator, Logger logger, TestSystemFactory testSystemFactory, TestSystemListener testSystemListener, FormatterFactory formatterFactory, Properties properties, SystemVariableSource variableSource, String theme) {
        this.version = version;
        this.wikiPageFactory = wikiPageFactory;
        this.rootPath = rootPath;
        this.rootDirectoryName = rootDirectoryName;
        this.contextRoot = contextRoot;
        this.versionsController = versionsController;
        this.recentChanges = recentChanges;
        this.port = port;
        this.authenticator = authenticator;
        this.logger = logger;
        this.testSystemFactory = testSystemFactory;
        this.testSystemListener = testSystemListener;
        this.formatterFactory = formatterFactory;
        this.properties = properties;
        this.theme = theme;
        this.responderFactory = new ResponderFactory(this.getRootPagePath());
        this.variableSource = variableSource;
        this.fitNesse = new FitNesse(this);
        this.pageFactory = new PageFactory(this);
        this.testRunFactoryRegistry = new TestRunFactoryRegistry(this);
        this.testRunFactoryRegistry.addFactory(new FileBasedTestRunFactory(this));
    }

    public WikiPage getRootPage() {
        return this.getRootPage(this.variableSource);
    }

    public WikiPage getRootPage(Map<String, String> customProperties) {
        return this.getRootPage(new UrlPathVariableSource(this.variableSource, customProperties));
    }

    private WikiPage getRootPage(VariableSource variableSource) {
        return this.wikiPageFactory.makePage(new File(this.rootPath, this.rootDirectoryName), this.rootDirectoryName, null, variableSource);
    }

    public File getTestHistoryDirectory() {
        String testHistoryPath = this.getProperty("test.history.path");
        if (testHistoryPath == null) {
            testHistoryPath = String.format(this.unifiedPathPattern("%s/files/%s"), this.getRootPagePath(), testResultsDirectoryName);
        }
        return new File(testHistoryPath);
    }

    public String getTestProgressPath() {
        return String.format(this.unifiedPathPattern("%s/files/testProgress"), this.getRootPagePath());
    }

    public String getRootPagePath() {
        return String.format(this.unifiedPathPattern("%s/%s"), this.rootPath, this.rootDirectoryName);
    }

    public Properties getProperties() {
        return this.properties;
    }

    public String getProperty(String name) {
        return this.variableSource.getProperty(name);
    }

    private String unifiedPathPattern(String s) {
        return StringUtils.replace(s, "/", File.separator);
    }
}

