/*
 * Decompiled with CFR 0.152.
 */
package fitnesse;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FitNesseVersion {
    private static final Logger LOG = Logger.getLogger(FitNesseVersion.class.getName());
    private static final String UNKNOWN_VERSION = "vUnknown";
    private final String version;

    public FitNesseVersion() {
        this(FitNesseVersion.versionFromMetaInf());
    }

    public FitNesseVersion(String version) {
        this.version = version;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String versionFromMetaInf() {
        InputStream is = null;
        try {
            is = FitNesseVersion.class.getResourceAsStream("/META-INF/FitNesseVersion.txt");
            if (is == null) {
                String string = UNKNOWN_VERSION;
                return string;
            }
            byte[] b = new byte[64];
            int len = is.read(b);
            String string = new String(b, 0, len, Charset.forName("ISO-8859-1"));
            return string;
        }
        catch (IOException e) {
            LOG.log(Level.WARNING, "Unable to read FitNesse version", e);
            String string = UNKNOWN_VERSION;
            return string;
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    LOG.log(Level.SEVERE, "Unable to close FitNesse version file (should never happen)", e);
                }
            }
        }
    }

    public String toString() {
        return this.version;
    }

    static Long dateVersion(String fullTextVersion) {
        try {
            return Long.parseLong(fullTextVersion.substring(1, Math.min(9, fullTextVersion.length())));
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unable to extract date version from " + fullTextVersion, e);
        }
    }

    public boolean isAtLeast(String requiredVersion) {
        long otherVersion;
        long thisVersion = FitNesseVersion.dateVersion(this.version);
        return thisVersion >= (otherVersion = FitNesseVersion.dateVersion(requiredVersion).longValue());
    }
}

