/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.authentication;

import fitnesse.authentication.Authenticator;
import fitnesse.authentication.PasswordCipher;
import fitnesse.authentication.PasswordFile;
import java.io.IOException;
import java.util.Map;

public class MultiUserAuthenticator
extends Authenticator {
    private Map<String, String> users;
    private PasswordCipher cipher;

    public MultiUserAuthenticator(String passwdFile) throws IOException, ReflectiveOperationException {
        PasswordFile passwords = new PasswordFile(passwdFile);
        this.users = passwords.getPasswordMap();
        this.cipher = passwords.getCipher();
    }

    @Override
    public boolean isAuthenticated(String username, String password) {
        if (username == null || password == null) {
            return false;
        }
        String foundPassword = this.users.get(username);
        if (foundPassword == null) {
            return false;
        }
        String encryptedPassword = this.cipher.encrypt(password);
        return encryptedPassword.equals(foundPassword);
    }

    public int userCount() {
        return this.users.size();
    }

    public String getPasswd(String user) {
        return this.users.get(user);
    }
}

