/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.components;

import fitnesse.ConfigurationParameter;
import fitnesse.components.ComponentInstantiationException;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class ComponentFactory {
    private final Properties properties;
    private final ClassLoader classLoader;
    private Map<String, Object> components;

    public ComponentFactory(Properties properties) {
        this(properties, ClassLoader.getSystemClassLoader());
    }

    public ComponentFactory(Properties properties, ClassLoader classLoader) {
        this.properties = properties;
        this.classLoader = classLoader;
        this.components = new HashMap<String, Object>();
    }

    public <T> T createComponent(String componentType, Class<T> defaultComponent) throws ComponentInstantiationException {
        Class<T> componentClass;
        if (this.components.containsKey(componentType)) {
            return (T)this.components.get(componentType);
        }
        String componentClassName = this.properties.getProperty(componentType);
        try {
            componentClass = componentClassName != null ? this.lookupComponentClass(componentClassName) : defaultComponent;
        }
        catch (Exception e) {
            throw new ComponentInstantiationException("Unable to look up component for type '" + componentType + "' with classname '" + componentClassName + "'", e);
        }
        if (componentClass != null) {
            T component = this.createComponent(componentClass);
            this.components.put(componentType, component);
            return component;
        }
        return null;
    }

    public <T> T createComponent(Class<T> componentClass) throws ComponentInstantiationException {
        try {
            try {
                Constructor<T> constructor = componentClass.getConstructor(ComponentFactory.class);
                return constructor.newInstance(this);
            }
            catch (NoSuchMethodException constructor) {
                try {
                    Constructor<T> constructor2 = componentClass.getConstructor(Properties.class);
                    return constructor2.newInstance(this.properties);
                }
                catch (NoSuchMethodException e) {
                    Constructor<T> constructor3 = componentClass.getConstructor(new Class[0]);
                    return constructor3.newInstance(new Object[0]);
                }
            }
        }
        catch (Exception e) {
            throw new ComponentInstantiationException("Unable to instantiate component for type " + componentClass.getName(), e);
        }
    }

    public <T> T createComponentForClassName(String className) {
        Class<T> clazz;
        try {
            clazz = this.lookupComponentClass(className);
        }
        catch (ClassNotFoundException e) {
            throw new ComponentInstantiationException("Unable to load class named " + className, e);
        }
        return this.createComponent(clazz);
    }

    public <T> Class<T> lookupComponentClass(String className) throws ClassNotFoundException {
        return this.classLoader.loadClass(className);
    }

    public <T> T createComponent(ConfigurationParameter componentType, Class<T> defaultComponent) {
        return this.createComponent(componentType.getKey(), defaultComponent);
    }

    public <T> T createComponent(ConfigurationParameter componentType) {
        return this.createComponent(componentType, null);
    }

    public String getProperty(String key) {
        return this.properties.getProperty(key);
    }

    public String getProperty(String key, String defaultValue) {
        return this.properties.getProperty(key, defaultValue);
    }
}

