/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.fixtures;

import fit.ActionFixture;
import fit.Parse;
import java.lang.reflect.Method;
import java.util.Stack;

public class LoopingActionFixture
extends ActionFixture {
    Stack<Parse> loopContexts = new Stack();
    Parse rows;

    boolean isSpecialName(String name) {
        return name.equals("do") || name.equals("while");
    }

    Method getAction(String name) throws SecurityException, NoSuchMethodException {
        String methodName = this.isSpecialName(name) ? "action_" + name : name;
        return this.getClass().getMethod(methodName, new Class[0]);
    }

    @Override
    public void doRows(Parse rows) {
        this.rows = rows;
        while (this.rows != null) {
            this.doRow(this.rows);
            this.rows = this.rows.more;
        }
    }

    @Override
    public void doCells(Parse cells) {
        this.cells = cells;
        try {
            Method action = this.getAction(cells.text());
            action.invoke((Object)this, new Object[0]);
        }
        catch (Exception e) {
            this.exception(cells, e);
        }
    }

    public void action_do() {
        this.loopContexts.push(this.rows);
    }

    public void action_while() throws Exception {
        String methodName = this.cells.more.text();
        Method action = this.getActor().getClass().getMethod(methodName, new Class[0]);
        Boolean result = (Boolean)action.invoke((Object)this.getActor(), new Object[0]);
        if (result.booleanValue()) {
            this.rows = this.loopContexts.peek();
        } else {
            this.loopContexts.pop();
        }
    }
}

