/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.fixtures;

import fit.ColumnFixture;
import fitnesse.fixtures.FitnesseFixtureContext;
import fitnesse.html.HtmlUtil;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ResponseExaminer
extends ColumnFixture {
    public String type;
    public String pattern;
    public String line;
    private String value;
    public int number;
    private Matcher matcher;
    private int currentLine = 0;
    private int currentPosition = 0;
    private int group = 0;

    public String contents() throws Exception {
        String sentData = FitnesseFixtureContext.sender.sentData();
        return HtmlUtil.escapeHTML(sentData);
    }

    public String html() throws Exception {
        String sentData = FitnesseFixtureContext.sender.sentData();
        int headerEnd = sentData.indexOf("\r\n\r\n");
        return sentData.substring(headerEnd + 4);
    }

    public String fullContents() throws Exception {
        return HtmlUtil.escapeHTML(FitnesseFixtureContext.sender.sentData());
    }

    public boolean inOrder() throws Exception {
        if (this.line == null) {
            return false;
        }
        String pageContent = FitnesseFixtureContext.sender.sentData();
        String[] lines = this.arrayifyLines(pageContent);
        String l = this.line.trim();
        for (int i = this.currentLine; i < lines.length; ++i) {
            if (!lines[i].trim().contains(l)) continue;
            this.currentLine = i;
            return true;
        }
        return false;
    }

    public boolean occursAfter() throws Exception {
        if (this.line == null) {
            return false;
        }
        String pageContent = FitnesseFixtureContext.sender.sentData();
        int matchPosition = pageContent.indexOf(this.line, this.currentPosition);
        if (matchPosition < 0) {
            return false;
        }
        this.currentPosition = matchPosition;
        return true;
    }

    public int matchCount() throws Exception {
        Pattern p = Pattern.compile(this.pattern, 40);
        this.extractValueFromResponse();
        this.matcher = p.matcher(this.getValue());
        int matches = 0;
        while (this.matcher.find()) {
            ++matches;
        }
        return matches;
    }

    public void extractValueFromResponse() throws Exception {
        this.setValue(null);
        if (this.type.equals("contents")) {
            this.setValue(HtmlUtil.unescapeHTML(FitnesseFixtureContext.sender.sentData()));
        } else if (this.type.equals("fullContents")) {
            this.setValue(this.fullContents());
        } else if (this.type.equals("rawContents")) {
            this.setValue(FitnesseFixtureContext.sender.sentData());
        } else if (this.type.equals("stringContents")) {
            this.setValue(FitnesseFixtureContext.sender.toString());
        } else if (this.type.equals("pageContents")) {
            this.setValue(FitnesseFixtureContext.page.toString());
        } else if (this.type.equals("pageHtml")) {
            this.setValue(FitnesseFixtureContext.page.getHtml());
        } else if (this.type.equals("matchers")) {
            this.setValue(this.matcher.group(this.group));
        } else if (this.type.equals("status")) {
            this.setValue("" + FitnesseFixtureContext.response.getStatus());
        } else if (this.type.equals("headers")) {
            String text = FitnesseFixtureContext.sender.sentData();
            int headerEnd = text.indexOf("\r\n\r\n");
            this.setValue(text.substring(0, headerEnd + 2));
        }
    }

    public boolean matches() throws Exception {
        return this.matchCount() > 0;
    }

    public String string() throws Exception {
        if (this.type.equals("contents")) {
            return FitnesseFixtureContext.page.getHtml();
        }
        if (this.type.equals("line")) {
            return this.getLine(this.number);
        }
        throw new Exception("Bad type in ResponseExaminer");
    }

    private String getLine(int number) throws Exception {
        String value = null;
        String pageContent = FitnesseFixtureContext.page.getHtml();
        String lineizedContent = ResponseExaminer.convertBreaksToLineSeparators(pageContent);
        StringTokenizer tokenizedLines = this.tokenizeLines(lineizedContent);
        for (int i = number; i != 0; --i) {
            value = tokenizedLines.nextToken();
        }
        return value != null ? value.trim() : null;
    }

    private StringTokenizer tokenizeLines(String lineizedContent) {
        return new StringTokenizer(lineizedContent, System.getProperty("line.separator"));
    }

    private String[] arrayifyLines(String lineizedContent) {
        return lineizedContent.split(System.getProperty("line.separator"));
    }

    public static String convertBreaksToLineSeparators(String pageContent) {
        return pageContent.replaceAll("<br/>", System.getProperty("line.separator"));
    }

    public String found() throws Exception {
        return this.found(this.group);
    }

    public String found(int group) throws Exception {
        Pattern p = Pattern.compile(this.pattern, 40);
        this.extractValueFromResponse();
        this.matcher = p.matcher(this.getValue());
        return this.matcher.find() ? this.matcher.group(group) : null;
    }

    public Matcher matcher() {
        return this.matcher;
    }

    public String source() {
        return this.getValue();
    }

    public String wrappedHtml() throws Exception {
        String txt = FitnesseFixtureContext.sender.sentData();
        String txt2 = txt.replaceAll("(<br */?>)", "$1" + System.getProperty("line.separator"));
        return "<pre>" + HtmlUtil.escapeHTML(txt2) + "</pre>";
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public void setNumber(int number) {
        this.number = number;
    }

    public void setGroup(int number) {
        this.group = number;
    }

    public String getValue() {
        return this.value;
    }

    public void setLine(String line) {
        this.line = line;
    }
}

