/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.html.template;

import fitnesse.FitNesseContext;
import fitnesse.html.template.ClasspathResourceLoader;
import fitnesse.html.template.EscapeDirective;
import fitnesse.html.template.HtmlPage;
import fitnesse.html.template.TraverseDirective;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Properties;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import util.FileUtil;

public class PageFactory {
    private final String theme;
    private final String contextRoot;
    private VelocityEngine velocityEngine = null;

    public PageFactory(FitNesseContext context) {
        this.theme = context.theme;
        this.velocityEngine = this.newVelocityEngine(context.getRootPagePath(), this.theme);
        this.contextRoot = context.contextRoot;
    }

    public HtmlPage newPage() {
        return new HtmlPage(this.getVelocityEngine(), "skeleton.vm", this.theme, this.contextRoot);
    }

    public String render(VelocityContext context, String templateName) {
        StringWriter writer = new StringWriter();
        Template template = this.getVelocityEngine().getTemplate(templateName, FileUtil.CHARENCODING);
        template.merge((Context)context, (Writer)writer);
        return ((Object)writer).toString();
    }

    public String getTheme() {
        return this.theme;
    }

    public VelocityEngine getVelocityEngine() {
        return this.velocityEngine;
    }

    public String toString() {
        return this.getClass().getName();
    }

    private VelocityEngine newVelocityEngine(String rootPagePath, String theme) {
        Properties properties = new Properties();
        properties.setProperty("directive.if.empty_check", "false");
        properties.setProperty("resource.default_encoding", FileUtil.CHARENCODING);
        properties.setProperty("resource.loaders", "file,themepath,classpath");
        properties.setProperty("resource.loader.file.path", String.format("%s/files/fitnesse/templates", rootPagePath));
        properties.setProperty("resource.loader.themepath.class", ClasspathResourceLoader.class.getName());
        properties.setProperty("resource.loader.themepath.base", String.format("/fitnesse/resources/%s/templates", theme));
        properties.setProperty("resource.loader.classpath.class", ClasspathResourceLoader.class.getName());
        properties.setProperty("resource.loader.classpath.base", "/fitnesse/resources/templates");
        VelocityEngine engine = new VelocityEngine();
        engine.init(properties);
        engine.loadDirective(TraverseDirective.class.getName());
        engine.loadDirective(EscapeDirective.class.getName());
        return engine;
    }
}

