/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.http;

import fitnesse.http.ChunkedDataProvider;
import fitnesse.http.Response;
import fitnesse.http.ResponseSender;
import java.io.Closeable;
import java.io.IOException;
import java.io.Writer;
import java.nio.ByteBuffer;

public class ChunkedResponse
extends Response
implements Closeable {
    private ResponseSender sender;
    private int bytesSent = 0;
    private boolean dontChunk = false;
    private ChunkedDataProvider chunckedDataProvider;
    private boolean chunksClosed = false;
    private boolean trailerClosed = false;

    public ChunkedResponse(String format, ChunkedDataProvider chunckedDataProvider) {
        super(format);
        this.chunckedDataProvider = chunckedDataProvider;
        if (this.isTextFormat()) {
            this.dontChunk = true;
        }
    }

    @Override
    public void sendTo(ResponseSender sender) throws IOException {
        this.sender = sender;
        sender.send(this.makeHttpHeaders().getBytes());
        this.chunckedDataProvider.startSending();
    }

    @Override
    protected void addContentHeaders() {
        super.addContentHeaders();
        if (!this.dontChunk) {
            this.addHeader("Transfer-Encoding", "chunked");
        }
    }

    public static String asHex(int value) {
        return Integer.toHexString(value);
    }

    public void add(String text) throws IOException {
        if (text != null) {
            this.add(this.getEncodedBytes(text));
        }
    }

    public void add(byte[] bytes) throws IOException {
        if (bytes == null || bytes.length == 0) {
            return;
        }
        if (this.dontChunk) {
            this.sender.send(bytes);
        } else {
            if (this.chunksClosed) {
                throw new IllegalStateException("Cannot add bytes after closing chunks");
            }
            String sizeLine = ChunkedResponse.asHex(bytes.length) + "\r\n";
            ByteBuffer chunk = ByteBuffer.allocate(sizeLine.length() + bytes.length + 2);
            chunk.put(sizeLine.getBytes()).put(bytes).put("\r\n".getBytes());
            this.sender.send(chunk.array());
        }
        this.bytesSent += bytes.length;
    }

    public void addTrailingHeader(String key, String value) throws IOException {
        if (!this.dontChunk) {
            if (this.trailerClosed) {
                throw new IllegalStateException("Cannot add headers after closing trailer");
            }
            this.closeChunks();
            String header = this.appendHeader(new StringBuilder(), key, value).toString();
            this.sender.send(header.getBytes());
        }
    }

    public void closeChunks() throws IOException {
        if (!this.dontChunk && !this.chunksClosed) {
            this.chunksClosed = true;
            this.sender.send("0\r\n".getBytes());
        }
    }

    public void closeTrailer() throws IOException {
        if (!this.dontChunk && !this.trailerClosed) {
            this.trailerClosed = true;
            this.sender.send("\r\n".getBytes());
        }
    }

    @Override
    public void close() throws IOException {
        this.closeChunks();
        this.closeTrailer();
        this.sender.close();
    }

    @Override
    public int getContentSize() {
        return this.bytesSent;
    }

    public void turnOffChunking() {
        this.dontChunk = true;
    }

    public boolean isChunkingTurnedOff() {
        return this.dontChunk;
    }

    public Writer getWriter() {
        return new Writer(){

            @Override
            public void close() throws IOException {
            }

            @Override
            public void flush() throws IOException {
            }

            @Override
            public void write(String str) throws IOException {
                ChunkedResponse.this.add(str);
            }

            @Override
            public void write(char[] cbuf, int off, int len) throws IOException {
                this.write(new String(cbuf, off, len));
            }
        };
    }
}

