/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.http;

import fitnesse.http.Response;
import fitnesse.http.ResponseSender;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import util.FileUtil;

public class MockResponseSender
implements ResponseSender {
    private final OutputStream output;
    protected boolean closed;

    public MockResponseSender() {
        this(new ByteArrayOutputStream());
    }

    public MockResponseSender(OutputStream output) {
        this.output = output;
    }

    @Override
    public void send(byte[] bytes) throws IOException {
        this.output.write(bytes);
    }

    @Override
    public void close() {
        this.closed = true;
    }

    public String sentData() throws UnsupportedEncodingException {
        return ((ByteArrayOutputStream)this.output).toString(FileUtil.CHARENCODING);
    }

    public void doSending(Response response) throws IOException {
        response.sendTo(this);
        assert (this.closed);
    }

    public boolean isClosed() {
        return this.closed;
    }
}

