/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.http;

import fitnesse.http.Response;
import fitnesse.http.ResponseSender;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;

public class SimpleResponse
extends Response {
    private byte[] content = new byte[0];

    public SimpleResponse() {
        super("html");
    }

    public SimpleResponse(int status) {
        super("html", status);
    }

    @Override
    public void sendTo(ResponseSender sender) throws IOException {
        try {
            sender.send(this.makeHttpHeaders().getBytes());
            sender.send(this.content);
        }
        finally {
            sender.close();
        }
    }

    public void setContent(String value) throws UnsupportedEncodingException {
        this.content = this.getEncodedBytes(value);
    }

    public void setContent(byte[] value) {
        this.content = Arrays.copyOf(value, value.length);
    }

    public String toString() {
        return String.format("status = %s,  contentType = %s, content = %s", this.getStatus(), this.getContentType(), this.getContent());
    }

    public String getContent() {
        return new String(this.content);
    }

    public byte[] getContentBytes() {
        return Arrays.copyOf(this.content, this.content.length);
    }

    @Override
    public int getContentSize() {
        return this.content.length;
    }

    @Override
    protected void addContentHeaders() {
        super.addContentHeaders();
        this.addHeader("Content-Length", String.valueOf(this.getContentSize()));
    }
}

