/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.junit;

import fitnesse.ConfigurationParameter;
import fitnesse.ContextConfigurator;
import fitnesse.FitNesseContext;
import fitnesse.junit.DescriptionFactory;
import fitnesse.junit.JUnitHelper;
import fitnesse.junit.JUnitRunNotifierResultsListener;
import fitnesse.junit.JavaFormatter;
import fitnesse.testrunner.MultipleTestsRunner;
import fitnesse.testrunner.SuiteContentsFinder;
import fitnesse.testrunner.run.TestRun;
import fitnesse.testsystems.ConsoleExecutionLogListener;
import fitnesse.testsystems.TestExecutionException;
import fitnesse.testsystems.TestSummary;
import fitnesse.wiki.WikiPage;
import java.io.File;
import java.io.IOException;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.junit.Assert;
import org.junit.runner.Description;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.ParentRunner;
import org.junit.runners.model.InitializationError;

public class FitNesseRunner
extends ParentRunner<WikiPage> {
    private Class<?> suiteClass;
    private String suiteName;
    private String outputDir;
    private String suiteFilter;
    private boolean suiteFilterAndStrategy;
    private String excludeSuiteFilter;
    private Pair<Integer, Integer> partition;
    private String partitionFile;
    private boolean debugMode;
    private boolean preventSystemExit;
    private FitNesseContext context;
    private DescriptionFactory descriptionFactory = new DescriptionFactory();
    private TestRun testRun;
    private List<WikiPage> children;

    public FitNesseRunner(Class<?> suiteClass) throws InitializationError {
        super(suiteClass);
    }

    protected void collectInitializationErrors(List<Throwable> errors) {
        super.collectInitializationErrors(errors);
        this.suiteClass = this.getTestClass().getJavaClass();
        try {
            this.suiteName = this.getSuiteName(this.suiteClass);
        }
        catch (Exception e) {
            errors.add(e);
        }
        try {
            this.outputDir = this.getOutputDir(this.suiteClass);
        }
        catch (Exception e) {
            errors.add(e);
        }
        try {
            this.suiteFilter = this.getSuiteFilter(this.suiteClass);
        }
        catch (Exception e) {
            errors.add(e);
        }
        try {
            this.suiteFilterAndStrategy = this.getSuiteFilterAndStrategy(this.suiteClass);
        }
        catch (Exception e) {
            errors.add(e);
        }
        try {
            this.excludeSuiteFilter = this.getExcludeSuiteFilter(this.suiteClass);
        }
        catch (Exception e) {
            errors.add(e);
        }
        try {
            this.partition = this.getPartition(this.suiteClass);
        }
        catch (Exception e) {
            errors.add(e);
        }
        try {
            this.partitionFile = this.getPartitionFile(this.suiteClass);
        }
        catch (Exception e) {
            errors.add(e);
        }
        try {
            this.debugMode = this.useDebugMode(this.suiteClass);
        }
        catch (Exception e) {
            errors.add(e);
        }
        try {
            this.preventSystemExit = this.shouldPreventSystemExit(this.suiteClass);
        }
        catch (Exception e) {
            errors.add(e);
        }
        try {
            this.context = this.createContext(this.suiteClass);
        }
        catch (Exception e) {
            errors.add(e);
        }
    }

    protected FitNesseContext createContext(Class<?> suiteClass) throws Exception {
        return this.initContextConfigurator().makeFitNesseContext();
    }

    protected String getSuiteName(Class<?> klass) throws InitializationError {
        Suite suiteAnnotation = klass.getAnnotation(Suite.class);
        if (suiteAnnotation == null) {
            throw new InitializationError("There must be a @Suite annotation");
        }
        if (!"".equals(suiteAnnotation.value())) {
            return suiteAnnotation.value();
        }
        if (!"".equals(suiteAnnotation.systemProperty())) {
            return System.getProperty(suiteAnnotation.systemProperty());
        }
        throw new InitializationError("In annotation @Suite you have to specify either 'value' or 'systemProperty'");
    }

    protected String getOutputDir(Class<?> klass) throws InitializationError {
        OutputDir outputDirAnnotation = klass.getAnnotation(OutputDir.class);
        if (outputDirAnnotation == null) {
            throw new InitializationError("There must be a @OutputDir annotation");
        }
        if (!"".equals(outputDirAnnotation.value())) {
            return outputDirAnnotation.value();
        }
        if (!"".equals(outputDirAnnotation.systemProperty())) {
            String baseDir = System.getProperty(outputDirAnnotation.systemProperty());
            File outputDir = new File(baseDir, outputDirAnnotation.pathExtension());
            return outputDir.getAbsolutePath();
        }
        throw new InitializationError("In annotation @OutputDir you have to specify either 'value' or 'systemProperty'");
    }

    protected String getSuiteFilter(Class<?> klass) throws Exception {
        SuiteFilter suiteFilterAnnotation = klass.getAnnotation(SuiteFilter.class);
        if (suiteFilterAnnotation == null) {
            return null;
        }
        if (!"".equals(suiteFilterAnnotation.value())) {
            return suiteFilterAnnotation.value();
        }
        if (!"".equals(suiteFilterAnnotation.systemProperty())) {
            return System.getProperty(suiteFilterAnnotation.systemProperty());
        }
        throw new InitializationError("In annotation @SuiteFilter you have to specify either 'value' or 'systemProperty'");
    }

    protected boolean getSuiteFilterAndStrategy(Class<?> klass) throws Exception {
        SuiteFilter suiteFilterAnnotation = klass.getAnnotation(SuiteFilter.class);
        if (suiteFilterAnnotation == null) {
            return false;
        }
        return suiteFilterAnnotation.andStrategy();
    }

    protected String getExcludeSuiteFilter(Class<?> klass) throws Exception {
        ExcludeSuiteFilter excludeSuiteFilterAnnotation = klass.getAnnotation(ExcludeSuiteFilter.class);
        if (excludeSuiteFilterAnnotation == null) {
            return null;
        }
        if (!"".equals(excludeSuiteFilterAnnotation.value())) {
            return excludeSuiteFilterAnnotation.value();
        }
        if (!"".equals(excludeSuiteFilterAnnotation.systemProperty())) {
            return System.getProperty(excludeSuiteFilterAnnotation.systemProperty());
        }
        throw new InitializationError("In annotation @ExcludeSuiteFilter you have to specify either 'value' or 'systemProperty'");
    }

    protected boolean useDebugMode(Class<?> klass) throws Exception {
        DebugMode debugModeAnnotation = klass.getAnnotation(DebugMode.class);
        if (null == debugModeAnnotation) {
            return true;
        }
        return debugModeAnnotation.value();
    }

    protected boolean shouldPreventSystemExit(Class<?> klass) throws Exception {
        PreventSystemExit preventSystemExitAnnotation = klass.getAnnotation(PreventSystemExit.class);
        if (null == preventSystemExitAnnotation) {
            return true;
        }
        return preventSystemExitAnnotation.value();
    }

    protected String getFitNesseDir(Class<?> klass) throws InitializationError {
        FitnesseDir fitnesseDirAnnotation = klass.getAnnotation(FitnesseDir.class);
        if (fitnesseDirAnnotation == null) {
            throw new InitializationError("There must be a @FitnesseDir annotation");
        }
        if (!"".equals(fitnesseDirAnnotation.value())) {
            return fitnesseDirAnnotation.value();
        }
        if (!"".equals(fitnesseDirAnnotation.systemProperty())) {
            String baseDir = System.getProperty(fitnesseDirAnnotation.systemProperty());
            File outputDir = new File(baseDir);
            return outputDir.getAbsolutePath();
        }
        throw new InitializationError("In annotation @FitnesseDir you have to specify either 'value' or 'systemProperty'");
    }

    protected String getFitNesseRoot(Class<?> klass) {
        FitnesseDir fitnesseDirAnnotation = klass.getAnnotation(FitnesseDir.class);
        return fitnesseDirAnnotation.fitNesseRoot();
    }

    protected ImmutablePair<Integer, Integer> getPartition(Class<?> klass) throws InitializationError {
        Partition partAnnotation = klass.getAnnotation(Partition.class);
        if (partAnnotation == null) {
            return new ImmutablePair((Object)1, (Object)0);
        }
        if (partAnnotation.count() > 0 && partAnnotation.index() >= 0) {
            return new ImmutablePair((Object)partAnnotation.count(), (Object)partAnnotation.index());
        }
        String countSystemProperty = partAnnotation.countSystemProperty();
        String indexSystemProperty = partAnnotation.indexSystemProperty();
        if (!"".equals(countSystemProperty) && !"".equals(indexSystemProperty)) {
            int count = Integer.parseInt(System.getProperty(countSystemProperty));
            int index = Integer.parseInt(System.getProperty(indexSystemProperty));
            return new ImmutablePair((Object)count, (Object)index);
        }
        throw new InitializationError("In annotation @Partition you have to specify: either 'count' or 'countSystemProperty' and either 'index' or 'indexSystemProperty'");
    }

    protected String getPartitionFile(Class<?> klass) throws Exception {
        PartitionFile partFileAnnotation = klass.getAnnotation(PartitionFile.class);
        if (partFileAnnotation == null) {
            return null;
        }
        if (!"".equals(partFileAnnotation.value())) {
            return partFileAnnotation.value();
        }
        if (!"".equals(partFileAnnotation.systemProperty())) {
            return System.getProperty(partFileAnnotation.systemProperty());
        }
        throw new InitializationError("In annotation @PartitionFile you have to specify either 'value' or 'systemProperty'");
    }

    public int getPort(Class<?> klass) {
        Port portAnnotation = klass.getAnnotation(Port.class);
        if (null == portAnnotation) {
            return 0;
        }
        int lport = portAnnotation.value();
        if (!"".equals(portAnnotation.systemProperty())) {
            lport = Integer.getInteger(portAnnotation.systemProperty(), lport);
        }
        return lport;
    }

    protected File getConfigFile(String rootPath, Class<?> klass) {
        ConfigFile configFileAnnotation = klass.getAnnotation(ConfigFile.class);
        if (null == configFileAnnotation) {
            return new File(rootPath, "plugins.properties");
        }
        return new File(configFileAnnotation.value());
    }

    protected Description describeChild(WikiPage child) {
        return this.getDescriptionFactory().createDescription(this.suiteClass, child);
    }

    protected TestRun getTestRun() {
        if (this.testRun == null) {
            List<WikiPage> allChildren = this.initChildren();
            this.testRun = this.createTestRun(allChildren);
        }
        return this.testRun;
    }

    protected List<WikiPage> getChildren() {
        if (this.children == null) {
            this.children = this.getTestRun().getPages();
        }
        return this.children;
    }

    public void run(RunNotifier notifier) {
        TestRun run = this.getTestRun();
        this.runPages(run, notifier);
    }

    protected void runChild(WikiPage page, RunNotifier notifier) {
        this.runPages(this.listOf(page), notifier);
    }

    protected void runPages(List<WikiPage> pages, RunNotifier notifier) {
        TestRun run = this.createTestRun(pages);
        this.runPages(run, notifier);
    }

    protected void runPages(TestRun run, RunNotifier notifier) {
        MultipleTestsRunner testRunner = JUnitHelper.createTestRunner(run, this.context, this.debugMode);
        this.addTestSystemListeners(notifier, testRunner, this.suiteClass, this.getDescriptionFactory());
        this.addExecutionLogListener(notifier, testRunner, this.suiteClass);
        System.setProperty("prevent.system.exit", String.valueOf(this.preventSystemExit));
        try {
            this.executeTests(testRunner);
        }
        catch (AssertionError | Exception e) {
            Description description = this.getDescriptionFactory().createSuiteDescription(this.suiteClass);
            notifier.fireTestFailure(new Failure(description, (Throwable)e));
        }
    }

    protected TestRun createTestRun(List<WikiPage> pages) {
        return JUnitHelper.createTestRun(this.context, pages);
    }

    protected void addTestSystemListeners(RunNotifier notifier, MultipleTestsRunner testRunner, Class<?> suiteClass, DescriptionFactory descriptionFactory) {
        testRunner.addTestSystemListener(new JUnitRunNotifierResultsListener(notifier, suiteClass, descriptionFactory));
    }

    protected void addExecutionLogListener(RunNotifier notifier, MultipleTestsRunner testRunner, Class<?> suiteClass) {
        testRunner.addExecutionLogListener(new ConsoleExecutionLogListener());
    }

    protected List<WikiPage> initChildren() {
        Map<String, String> customProperties = this.createCustomProperties();
        WikiPage suiteRoot = JUnitHelper.getSuiteRootPage(this.suiteName, this.context, customProperties);
        if (suiteRoot == null) {
            throw new IllegalArgumentException("No page " + this.suiteName);
        }
        if (suiteRoot.getData().hasAttribute("Suite")) {
            SuiteContentsFinder contentsFinder = new SuiteContentsFinder(suiteRoot, this.getSuiteFilter(), this.context.getRootPage());
            return contentsFinder.getAllPagesToRunForThisSuite();
        }
        List<WikiPage> children = Collections.singletonList(suiteRoot);
        return children;
    }

    protected Map<String, String> createCustomProperties() {
        HashMap<String, String> customProperties = new HashMap<String, String>();
        Integer partitionCount = (Integer)this.partition.getLeft();
        if (partitionCount > 1) {
            customProperties.put("partitionCount", partitionCount.toString());
            customProperties.put("partitionIndex", ((Integer)this.partition.getRight()).toString());
        }
        if (this.partitionFile != null) {
            customProperties.put("partitionIndexFile", this.partitionFile);
        }
        return customProperties;
    }

    private fitnesse.testrunner.SuiteFilter getSuiteFilter() {
        return new fitnesse.testrunner.SuiteFilter(this.getOrSuiteFilter(), this.excludeSuiteFilter, this.getAndSuiteFilter(), null);
    }

    private String getOrSuiteFilter() {
        return this.suiteFilterAndStrategy ? null : this.suiteFilter;
    }

    private String getAndSuiteFilter() {
        return this.suiteFilterAndStrategy ? this.suiteFilter : null;
    }

    protected ContextConfigurator initContextConfigurator() throws InitializationError {
        String rootPath = this.getFitNesseDir(this.suiteClass);
        String fitNesseRoot = this.getFitNesseRoot(this.suiteClass);
        int port = this.getPort(this.suiteClass);
        File configFile = this.getConfigFile(rootPath, this.suiteClass);
        return ContextConfigurator.systemDefaults().updatedWith(System.getProperties()).updatedWith(ConfigurationParameter.loadProperties(configFile)).updatedWith(ConfigurationParameter.makeProperties(new Object[]{ConfigurationParameter.PORT, port, ConfigurationParameter.ROOT_PATH, rootPath, ConfigurationParameter.ROOT_DIRECTORY, fitNesseRoot, ConfigurationParameter.OMITTING_UPDATES, true}));
    }

    private void executeTests(MultipleTestsRunner testRunner) throws IOException, TestExecutionException {
        JavaFormatter testFormatter = new JavaFormatter(this.suiteName);
        testFormatter.setResultsRepository(new JavaFormatter.FolderResultsRepository(this.outputDir));
        testRunner.addTestSystemListener(testFormatter);
        testRunner.executeTestPages();
        TestSummary summary = testFormatter.getTotalSummary();
        Assert.assertTrue((String)JUnitHelper.msgAtLeastOneTest(this.suiteName, summary), (summary.getRight() > 0 || summary.getWrong() > 0 || summary.getExceptions() > 0 ? 1 : 0) != 0);
    }

    private List<WikiPage> listOf(WikiPage page) {
        ArrayList<WikiPage> list = new ArrayList<WikiPage>(1);
        list.add(page);
        return list;
    }

    public DescriptionFactory getDescriptionFactory() {
        return this.descriptionFactory;
    }

    public void setDescriptionFactory(DescriptionFactory descriptionFactory) {
        this.descriptionFactory = descriptionFactory;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    public static @interface ConfigFile {
        public String value();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    @Deprecated
    public static @interface Port {
        public int value() default 0;

        public String systemProperty() default "";
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    public static @interface OutputDir {
        public String value() default "";

        public String systemProperty() default "";

        public String pathExtension() default "";
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    public static @interface FitnesseDir {
        public String value() default "";

        public String systemProperty() default "";

        public String fitNesseRoot() default "FitNesseRoot";
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    public static @interface PartitionFile {
        public String value() default "";

        public String systemProperty() default "";
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    public static @interface Partition {
        public int count() default 0;

        public int index() default -1;

        public String countSystemProperty() default "";

        public String indexSystemProperty() default "";
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    public static @interface ExcludeSuiteFilter {
        public String value();

        public String systemProperty() default "";
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    public static @interface SuiteFilter {
        public String value() default "";

        public String systemProperty() default "";

        public boolean andStrategy() default false;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    public static @interface PreventSystemExit {
        public boolean value() default true;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    public static @interface DebugMode {
        public boolean value();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    public static @interface Suite {
        public String value() default "";

        public String systemProperty() default "";
    }
}

