/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.junit;

import fitnesse.ContextConfigurator;
import fitnesse.FitNesseContext;
import fitnesse.junit.JavaFormatter;
import fitnesse.junit.PrintTestListener;
import fitnesse.testrunner.MultipleTestsRunner;
import fitnesse.testrunner.SuiteContentsFinder;
import fitnesse.testrunner.SuiteFilter;
import fitnesse.testrunner.run.TestRun;
import fitnesse.testsystems.ConsoleExecutionLogListener;
import fitnesse.testsystems.TestSummary;
import fitnesse.testsystems.TestSystemListener;
import fitnesse.wiki.PageCrawler;
import fitnesse.wiki.PathParser;
import fitnesse.wiki.WikiPage;
import fitnesse.wiki.WikiPagePath;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.junit.Assert;

public class JUnitHelper {
    public static final String PAGE_TYPE_SUITE = "suite";
    public static final String PAGE_TYPE_TEST = "test";
    private final String outputDir;
    private final String fitNesseRootPath;
    private final TestSystemListener resultsListener;
    private int port = 0;
    private boolean debugMode = true;

    public JUnitHelper(String fitNesseRootPath, String outputPath) {
        this(fitNesseRootPath, outputPath, new PrintTestListener());
    }

    public JUnitHelper(String fitNesseDir, String outputDir, TestSystemListener resultsListener) {
        this.fitNesseRootPath = fitNesseDir;
        this.outputDir = outputDir;
        this.resultsListener = resultsListener;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setDebugMode(boolean enabled) {
        this.debugMode = enabled;
    }

    public void assertTestPasses(String testName) throws Exception {
        this.assertPasses(testName, PAGE_TYPE_TEST, null);
    }

    public void assertSuitePasses(String suiteName) throws Exception {
        this.assertPasses(suiteName, PAGE_TYPE_SUITE, null);
    }

    public void assertSuitePasses(String suiteName, String suiteFilter) throws Exception {
        this.assertPasses(suiteName, PAGE_TYPE_SUITE, suiteFilter);
    }

    public void assertSuitePasses(String suiteName, String suiteFilter, String excludeSuiteFilter) throws Exception {
        this.assertPasses(suiteName, PAGE_TYPE_SUITE, suiteFilter, excludeSuiteFilter);
    }

    public void assertPasses(String pageName, String pageType, String suiteFilter) throws Exception {
        this.assertPasses(pageName, pageType, suiteFilter, null);
    }

    public void assertPasses(String pageName, String pageType, String suiteFilter, String excludeSuiteFilter) throws Exception {
        FitNesseContext context = ContextConfigurator.systemDefaults().withRootPath(this.fitNesseRootPath).withPort(this.port).makeFitNesseContext();
        JavaFormatter testFormatter = new JavaFormatter(pageName);
        testFormatter.setResultsRepository(new JavaFormatter.FolderResultsRepository(this.outputDir));
        List<WikiPage> pages = this.initChildren(pageName, suiteFilter, excludeSuiteFilter, context);
        TestRun run = JUnitHelper.createTestRun(context, pages);
        MultipleTestsRunner testRunner = JUnitHelper.createTestRunner(run, context, this.debugMode);
        testRunner.addTestSystemListener(testFormatter);
        testRunner.addTestSystemListener(this.resultsListener);
        testRunner.addExecutionLogListener(new ConsoleExecutionLogListener());
        testRunner.executeTestPages();
        TestSummary summary = testFormatter.getTotalSummary();
        Assert.assertEquals((String)"wrong", (long)0L, (long)summary.getWrong());
        Assert.assertEquals((String)"exceptions", (long)0L, (long)summary.getExceptions());
        Assert.assertTrue((String)JUnitHelper.msgAtLeastOneTest(pageName, summary), (summary.getRight() > 0 ? 1 : 0) != 0);
    }

    private List<WikiPage> initChildren(String suiteName, String suiteFilter, String excludeSuiteFilter, FitNesseContext context) {
        WikiPage suiteRoot = JUnitHelper.getSuiteRootPage(suiteName, context, Collections.emptyMap());
        if (!suiteRoot.getData().hasAttribute("Suite")) {
            return Arrays.asList(suiteRoot);
        }
        return new SuiteContentsFinder(suiteRoot, new SuiteFilter(suiteFilter, excludeSuiteFilter), context.getRootPage()).getAllPagesToRunForThisSuite();
    }

    static WikiPage getSuiteRootPage(String suiteName, FitNesseContext context, Map<String, String> customProperties) {
        WikiPagePath path = PathParser.parse(suiteName);
        PageCrawler crawler = context.getRootPage(customProperties).getPageCrawler();
        return crawler.getPage(path);
    }

    static MultipleTestsRunner createTestRunner(TestRun run, FitNesseContext context, boolean debugMode) {
        MultipleTestsRunner runner = new MultipleTestsRunner(run, context.testSystemFactory);
        runner.setRunInProcess(debugMode);
        return runner;
    }

    static TestRun createTestRun(FitNesseContext context, List<WikiPage> pages) {
        return context.testRunFactoryRegistry.createRun(pages);
    }

    static String msgAtLeastOneTest(String pageName, TestSummary summary) {
        return MessageFormat.format("at least one test executed in {0}\n{1}", pageName, summary.toString());
    }
}

