/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.junit;

import fitnesse.junit.JUnitXMLTestResultRecorder;
import fitnesse.util.TimeMeasurement;
import java.io.File;
import org.junit.runner.Description;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunListener;

public class JUnitXMLPerPageRunListener
extends RunListener {
    private static final String OUTPUT_PATH = "target/failsafe-reports/";
    private final JUnitXMLTestResultRecorder testResultRecorder;
    private TimeMeasurement timeMeasurement;

    public JUnitXMLPerPageRunListener() {
        this.testResultRecorder = new JUnitXMLTestResultRecorder(new File(OUTPUT_PATH));
    }

    public JUnitXMLPerPageRunListener(JUnitXMLTestResultRecorder jUnitXMLTestResultRecorder) {
        this.testResultRecorder = jUnitXMLTestResultRecorder;
    }

    public void testStarted(Description description) throws Exception {
        this.timeMeasurement = new TimeMeasurement().start();
        super.testStarted(description);
    }

    public void testFinished(Description description) throws Exception {
        super.testFinished(description);
        if (!this.timeMeasurement.isStopped()) {
            this.testResultRecorder.recordTestResult(this.getTestName(description), 0, 0, 0, null, this.getExecutionTime());
        }
    }

    public void testFailure(Failure failure) throws Exception {
        super.testFailure(failure);
        String testName = this.getTestName(failure.getDescription());
        Throwable throwable = failure.getException();
        long executionTime = this.getExecutionTime();
        if (throwable instanceof AssertionError) {
            this.testResultRecorder.recordTestResult(testName, 0, 1, 0, throwable, executionTime);
        } else {
            this.testResultRecorder.recordTestResult(testName, 0, 0, 1, throwable, executionTime);
        }
    }

    protected long getExecutionTime() {
        long executionTime = 0L;
        if (this.timeMeasurement != null) {
            executionTime = this.timeMeasurement.elapsed();
            if (!this.timeMeasurement.isStopped()) {
                this.timeMeasurement.stop();
            }
        }
        return executionTime;
    }

    protected String getOutputPath() {
        return OUTPUT_PATH;
    }

    protected String getTestName(Description description) {
        return description.getMethodName();
    }
}

