/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.junit;

import fitnesse.junit.JUnitXMLTestResultRecorder;
import java.io.File;
import java.io.IOException;
import org.gradle.api.tasks.testing.TestDescriptor;
import org.gradle.api.tasks.testing.TestListener;
import org.gradle.api.tasks.testing.TestResult;

public class JUnitXMLPerPageTestListener
implements TestListener {
    private final JUnitXMLTestResultRecorder testResultRecorder;

    public JUnitXMLPerPageTestListener(File reportsDir) {
        this.testResultRecorder = new JUnitXMLTestResultRecorder(reportsDir);
    }

    public JUnitXMLPerPageTestListener(JUnitXMLTestResultRecorder jUnitXMLTestResultRecorder) {
        this.testResultRecorder = jUnitXMLTestResultRecorder;
    }

    public void beforeSuite(TestDescriptor testDescriptor) {
    }

    public void afterSuite(TestDescriptor testDescriptor, TestResult testResult) {
    }

    public void beforeTest(TestDescriptor testDescriptor) {
    }

    public void afterTest(TestDescriptor testDescriptor, TestResult testResult) {
        switch (testResult.getResultType()) {
            case SUCCESS: {
                this.testSuccess(testDescriptor, testResult);
                break;
            }
            case FAILURE: {
                this.testFailure(testDescriptor, testResult);
                break;
            }
            case SKIPPED: {
                this.testSkipped(testDescriptor, testResult);
                break;
            }
            default: {
                throw new UnsupportedOperationException("ResultType " + testResult.getResultType() + " received. Only SUCCESS, SKIPPED and FAILURE are supported!");
            }
        }
    }

    protected void testFailure(TestDescriptor testDescriptor, TestResult result) {
        String testName = testDescriptor.getName();
        Throwable throwable = result.getException();
        long executionTime = this.calculateExecutionTimeInSeconds(result);
        try {
            if (throwable instanceof AssertionError) {
                this.testResultRecorder.recordTestResult(testName, 0, 1, 0, throwable, executionTime);
            } else {
                this.testResultRecorder.recordTestResult(testName, 0, 0, 1, throwable, executionTime);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected void testSkipped(TestDescriptor testDescriptor, TestResult result) {
        String testName = testDescriptor.getName();
        Throwable throwable = result.getException();
        long executionTime = this.calculateExecutionTimeInSeconds(result);
        try {
            if (throwable instanceof AssertionError) {
                this.testResultRecorder.recordTestResult(testName, 1, 0, 0, throwable, executionTime);
            } else {
                this.testResultRecorder.recordTestResult(testName, 0, 0, 1, throwable, executionTime);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected void testSuccess(TestDescriptor testDescriptor, TestResult result) {
        try {
            this.testResultRecorder.recordTestResult(testDescriptor.getName(), 0, 0, 0, null, this.calculateExecutionTimeInSeconds(result));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected long calculateExecutionTimeInSeconds(TestResult result) {
        return result.getEndTime() - result.getStartTime();
    }
}

