/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.junit;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import org.apache.commons.text.StringEscapeUtils;

public class JUnitXMLTestResultRecorder {
    private final File reportsDir;

    public JUnitXMLTestResultRecorder(File reportsDir) {
        this.reportsDir = reportsDir;
        this.reportsDir.mkdirs();
    }

    void recordTestResult(String testName, int skipped, int failures, int errors, Throwable throwable, long executionTime) throws IOException {
        String resultXml = this.generateResultXml(testName, skipped, failures, errors, throwable, (double)executionTime / 1000.0);
        this.writeResult(testName, resultXml);
    }

    private void writeResult(String testName, String resultXml) throws IOException {
        String finalPath = this.getXmlFileName(testName);
        try (BufferedWriter fw = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(finalPath), StandardCharsets.UTF_8));){
            fw.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
            fw.write(resultXml);
        }
    }

    private String getXmlFileName(String testName) {
        return new File(this.reportsDir, "TEST-" + testName + ".xml").getAbsolutePath();
    }

    private String generateResultXml(String testName, int skipped, int failures, int errors, Throwable throwable, double executionTime) {
        String failureXml = "";
        if (throwable != null) {
            failureXml = "<failure type=\"" + throwable.getClass().getName() + "\" message=\"" + this.getMessage(throwable) + "\"></failure>";
        }
        return "<testsuite errors=\"" + errors + "\" skipped=\"" + skipped + "\" tests=\"1\" time=\"" + executionTime + "\" failures=\"" + failures + "\" name=\"" + testName + "\"><properties></properties><testcase classname=\"" + testName + "\" time=\"" + executionTime + "\" name=\"" + testName + "\">" + failureXml + "</testcase></testsuite>";
    }

    private String getMessage(Throwable throwable) {
        String errorMessage = throwable.getMessage();
        return StringEscapeUtils.escapeXml10((String)errorMessage);
    }
}

