/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.reporting;

import fitnesse.reporting.BaseFormatter;
import fitnesse.testsystems.TestPage;
import fitnesse.testsystems.TestSummary;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.time.LocalDateTime;
import java.util.logging.Logger;

public class RerunSuiteFormatter
extends BaseFormatter
implements Closeable {
    private static final Logger LOG = Logger.getLogger(RerunSuiteFormatter.class.getName());
    private final File wikiFile;
    private final PrintWriter pw;
    private int errorCount = 0;

    public RerunSuiteFormatter(File targetFile) throws IOException {
        this.wikiFile = targetFile;
        if (!this.wikiFile.getParentFile().exists()) {
            this.wikiFile.getParentFile().mkdirs();
        } else if (this.wikiFile.exists()) {
            this.wikiFile.delete();
        }
        LOG.fine("Rerun suite will be made in: " + this.wikiFile.getAbsolutePath());
        this.pw = new PrintWriter(this.wikiFile, "utf-8");
    }

    @Override
    public void testComplete(TestPage testPage, TestSummary testSummary) {
        if (testSummary.getExceptions() > 0) {
            this.recordFailure(testPage);
        } else if (testSummary.getWrong() > 0) {
            this.recordFailure(testPage);
        }
    }

    @Override
    public int getErrorCount() {
        return this.errorCount;
    }

    @Override
    public void close() {
        this.pw.close();
        if (this.getErrorCount() == 0 && this.wikiFile.exists()) {
            this.wikiFile.delete();
        }
    }

    protected void recordFailure(TestPage testPage) {
        String testPageName = testPage.getName();
        if (!"SuiteSetUp".equals(testPageName) && !"SuiteTearDown".equals(testPageName)) {
            ++this.errorCount;
            if (this.errorCount == 1) {
                this.appendHeader(this.pw);
            }
            this.appendPageFailure(this.pw, testPage);
            this.pw.flush();
        }
    }

    protected void appendHeader(PrintWriter writer) {
        writer.append("---\nHelp: Lists tests failed during last run, so they can be run again (without running all tests that passed).\nSuite\n---\n\n");
        writer.append("!note This page is automatically generated when running tests. ");
        writer.append("It will be overwritten by the next Suite or Test execution.\n\n");
        writer.append("Tests failed (first failure was at ");
        writer.append(LocalDateTime.now().toString());
        writer.append("):\n\n");
    }

    protected void appendPageFailure(PrintWriter writer, TestPage testPage) {
        String pagePath = testPage.getFullPath();
        writer.append("!see [[");
        writer.append(pagePath);
        writer.append("][.");
        writer.append(pagePath);
        writer.append("]]\n");
    }
}

