/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.reporting;

import fitnesse.http.ChunkedResponse;
import fitnesse.reporting.BaseFormatter;
import fitnesse.reporting.FormatterException;
import fitnesse.testsystems.TestPage;
import fitnesse.testsystems.TestSummary;
import fitnesse.testsystems.TestSystem;
import fitnesse.util.TimeMeasurement;
import java.io.Closeable;
import java.io.IOException;
import java.text.SimpleDateFormat;

public class TestTextFormatter
extends BaseFormatter
implements Closeable {
    private ChunkedResponse response;
    private TimeMeasurement timeMeasurement;
    private TimeMeasurement totalTimeMeasurement;
    private int testCount = 0;
    private int failCount = 0;

    public TestTextFormatter(ChunkedResponse response) {
        this.response = response;
        this.totalTimeMeasurement = new TimeMeasurement().start();
    }

    @Override
    public void testSystemStarted(TestSystem testSystem) {
        this.writeData("\nStarting Test System: %s.\n", testSystem.getName());
    }

    @Override
    public void testStarted(TestPage page) {
        this.timeMeasurement = new TimeMeasurement().start();
    }

    @Override
    public void testOutputChunk(TestPage testPage, String output) {
    }

    @Override
    public void testComplete(TestPage page, TestSummary summary) {
        this.timeMeasurement.stop();
        this.updateCounters(summary);
        String timeString = new SimpleDateFormat("HH:mm:ss").format(this.timeMeasurement.startedAtDate());
        this.writeData("%s %s R:%-4d W:%-4d I:%-4d E:%-4d %s\t(%s)\t%.03f seconds\n", this.passFail(summary), timeString, summary.getRight(), summary.getWrong(), summary.getIgnores(), summary.getExceptions(), page.getName(), page.getFullPath(), this.timeMeasurement.elapsedSeconds());
    }

    private void writeData(String format, Object ... args) {
        try {
            this.response.add(String.format(format, args));
        }
        catch (IOException e) {
            throw new FormatterException("Unable to write data, abort", e);
        }
    }

    private void updateCounters(TestSummary summary) {
        ++this.testCount;
        if (summary.getWrong() > 0) {
            ++this.failCount;
        }
        if (summary.getExceptions() > 0) {
            ++this.failCount;
        }
    }

    private String passFail(TestSummary summary) {
        if (summary.getWrong() > 0) {
            return "F";
        }
        if (summary.getExceptions() > 0) {
            return "X";
        }
        return ".";
    }

    @Override
    public void close() throws IOException {
        this.totalTimeMeasurement.stop();
        this.response.add(String.format("--------\n%d Tests,\t%d Failures\t%.03f seconds.\n", this.testCount, this.failCount, this.totalTimeMeasurement.elapsedSeconds()));
    }
}

