/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.reporting.history;

import fitnesse.util.Clock;
import fitnesse.wiki.WikiPagePath;
import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import util.FileUtil;

public class HistoryPurger {
    private static final Logger LOG = Logger.getLogger(HistoryPurger.class.getName());
    private final File resultsDirectory;
    private final Date expirationDate;

    public HistoryPurger(File resultsDirectory, int days) {
        this.resultsDirectory = resultsDirectory;
        this.expirationDate = this.getDateDaysAgo(days);
    }

    public void deleteTestHistoryOlderThanDays() {
        File[] files = FileUtil.getDirectoryListing(this.resultsDirectory);
        this.deleteExpiredFiles(files);
    }

    public void deleteTestHistoryOlderThanDays(WikiPagePath path) {
        File[] files;
        String pageName = path.toString();
        String subPagePrefix = pageName + ".";
        for (File file : files = FileUtil.getDirectoryListing(this.resultsDirectory)) {
            String fileName = file.getName();
            if (!fileName.equals(pageName) && !fileName.startsWith(subPagePrefix)) continue;
            this.deleteIfExpired(file);
        }
    }

    private void deleteExpiredFiles(File[] files) {
        for (File file : files) {
            this.deleteIfExpired(file);
        }
    }

    public Date getDateDaysAgo(int days) {
        long now = Clock.currentTimeInMillis();
        long millisecondsPerDay = 86400000L;
        Date daysEarlier = new Date(now - millisecondsPerDay * (long)days);
        return daysEarlier;
    }

    private void deleteIfExpired(File file) {
        try {
            if (file.isDirectory()) {
                this.deleteDirectoryIfExpired(file);
            } else {
                this.deleteFileIfExpired(file);
            }
        }
        catch (IOException e) {
            LOG.log(Level.INFO, String.format("Unable to remove test history file %s", file.getPath()));
        }
    }

    private void deleteDirectoryIfExpired(File file) throws IOException {
        File[] files = FileUtil.listFiles(file);
        this.deleteExpiredFiles(files);
        if (FileUtil.isEmpty(file)) {
            FileUtil.deleteFileSystemDirectory(file);
        }
    }

    private void deleteFileIfExpired(File file) throws IOException {
        String name = file.getName();
        Date date = this.getDateFromPageHistoryFileName(name);
        if (date.getTime() < this.expirationDate.getTime()) {
            FileUtil.deleteFile(file);
        }
    }

    private Date getDateFromPageHistoryFileName(String name) {
        try {
            return this.tryExtractDateFromTestHistoryName(name);
        }
        catch (ParseException e) {
            LOG.log(Level.INFO, String.format("Can not determine date from test history file %s", name));
            return new Date();
        }
    }

    private Date tryExtractDateFromTestHistoryName(String testHistoryName) throws ParseException {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
        String dateString = testHistoryName.split("_")[0];
        return dateFormat.parse(dateString);
    }
}

