/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.responders;

import fitnesse.FitNesseContext;
import fitnesse.Responder;
import fitnesse.html.template.HtmlPage;
import fitnesse.http.Request;
import fitnesse.http.Response;
import fitnesse.http.SimpleResponse;

public class ErrorResponder
implements Responder {
    private Exception exception;
    private String message;
    private int statusCode;

    public ErrorResponder(Exception e) {
        this.exception = e;
        this.statusCode = 400;
    }

    public ErrorResponder(String message) {
        this(message, 400);
    }

    public ErrorResponder(String message, int statusCode) {
        this.message = message;
        this.statusCode = statusCode;
    }

    @Override
    public Response makeResponse(FitNesseContext context, Request request) throws Exception {
        SimpleResponse response = new SimpleResponse(this.statusCode);
        HtmlPage html = context.pageFactory.newPage();
        html.addTitles("Error Occurred");
        html.setMainTemplate("error");
        html.put("exception", this.exception);
        if (this.exception != null) {
            html.put("exception", this.exception);
        }
        if (this.message != null) {
            html.put("message", this.message);
        }
        response.setContent(html.html(request));
        return response;
    }

    public static String makeExceptionString(Throwable e) {
        StringBuilder builder = new StringBuilder();
        builder.append(e.toString()).append("\n");
        for (StackTraceElement stackTraceElement : e.getStackTrace()) {
            builder.append("\t").append(stackTraceElement).append("\n");
        }
        return builder.toString();
    }
}

