/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.responders;

import fitnesse.responders.WikiImporter;
import fitnesse.wiki.NoPruningStrategy;
import fitnesse.wiki.PageData;
import fitnesse.wiki.WikiPage;
import java.io.IOException;

public class MockWikiImporter
extends WikiImporter {
    public static final String mockContent = "mock importer content";
    public boolean fail;

    @Override
    protected void importRemotePageContent(WikiPage localPage) throws IOException {
        if (this.fail) {
            this.importerClient.pageImportError(localPage, new Exception("Import of remote page content failed"));
        } else {
            this.setMockContent(localPage);
        }
    }

    private void setMockContent(WikiPage localPage) {
        PageData data = localPage.getData();
        data.setContent(mockContent);
        localPage.commit(data);
    }

    @Override
    public void importWiki(WikiPage page) {
        for (WikiPage child : page.getChildren()) {
            child.getPageCrawler().traverse(this, new NoPruningStrategy());
        }
    }

    @Override
    public void process(WikiPage page) {
        this.setMockContent(page);
    }
}

