/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.responders;

import fitnesse.authentication.SecureOperation;
import fitnesse.authentication.SecureResponder;
import fitnesse.authentication.SecureWriteOperation;
import fitnesse.html.template.HtmlPage;
import fitnesse.html.template.PageTitle;
import fitnesse.http.ChunkedResponse;
import fitnesse.responders.ChunkingResponder;
import fitnesse.responders.WikiImporter;
import fitnesse.responders.WikiImportingTraverser;
import fitnesse.wiki.PageCrawler;
import fitnesse.wiki.PageData;
import fitnesse.wiki.PathParser;
import fitnesse.wiki.WikiImportProperty;
import fitnesse.wiki.WikiPage;

public class WikiImportingResponder
extends ChunkingResponder
implements SecureResponder {
    private final WikiImporter importer;
    public PageData data;
    private WikiImportingTraverser wikiImportingTraverser;

    public WikiImportingResponder() {
        this(new WikiImporter());
    }

    public WikiImportingResponder(WikiImporter wikiImporter) {
        this.importer = wikiImporter;
    }

    public static void handleImportProperties(HtmlPage html, WikiPage page) {
        PageData pageData = page.getData();
        if (WikiImportProperty.isImportedSubWiki(pageData)) {
            html.setBodyClass("imported");
            WikiImportProperty importProperty = WikiImportProperty.createFrom(pageData.getProperties());
            html.put("sourceUrl", importProperty.getSourceUrl());
        }
    }

    @Override
    protected void doSending() throws Exception {
        this.data = this.page.getData();
        this.wikiImportingTraverser = this.initializeImporter();
        HtmlPage htmlPage = this.makeHtml();
        htmlPage.render(this.response.getWriter(), this.request);
        this.response.close();
    }

    public WikiImportingTraverser initializeImporter() throws Exception {
        String remoteUrl = this.request.getInput("remoteUrl");
        this.setRemoteUserCredentialsOnImporter(this.importer);
        this.importer.setAutoUpdateSetting(this.request.hasInput("autoUpdate"));
        return new WikiImportingTraverser(this.importer, this.page, remoteUrl);
    }

    private void setRemoteUserCredentialsOnImporter(WikiImporter importer) {
        if (this.request.hasInput("remoteUsername")) {
            importer.setRemoteUsername(this.request.getInput("remoteUsername"));
        }
        if (this.request.hasInput("remotePassword")) {
            importer.setRemotePassword(this.request.getInput("remotePassword"));
        }
    }

    private HtmlPage makeHtml() throws Exception {
        HtmlPage html = this.context.pageFactory.newPage();
        String title = "Wiki Import";
        if (this.wikiImportingTraverser.isUpdate()) {
            title = title + " Update";
        }
        String localPathName = PathParser.render(this.path);
        html.setTitle(title + ": " + localPathName);
        html.setPageTitle(new PageTitle(title, this.path));
        html.setMainTemplate("wikiImportingPage");
        html.put("isUpdate", this.wikiImportingTraverser.isUpdate());
        String pageName = PathParser.render(this.path);
        html.put("pageName", pageName);
        html.put("remoteUrl", this.importer.remoteUrl());
        html.put("importer", this.importer);
        html.put("PathParser", PathParser.class);
        html.put("importTraverser", this.wikiImportingTraverser);
        return html;
    }

    @Override
    protected PageCrawler getPageCrawler() {
        return this.root.getPageCrawler();
    }

    public void setResponse(ChunkedResponse response) {
        this.response = response;
    }

    @Override
    public SecureOperation getSecureOperation() {
        return new SecureWriteOperation();
    }
}

