/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.responders.editing;

import fitnesse.FitNesseContext;
import fitnesse.authentication.AlwaysSecureOperation;
import fitnesse.authentication.SecureOperation;
import fitnesse.http.Request;
import fitnesse.http.Response;
import fitnesse.http.SimpleResponse;
import fitnesse.responders.BasicResponder;
import fitnesse.wiki.PageData;
import fitnesse.wiki.VersionInfo;
import fitnesse.wiki.WikiPage;
import java.util.Arrays;
import java.util.LinkedList;

public class SavePropertiesResponder
extends BasicResponder {
    @Override
    public Response makeResponse(FitNesseContext context, Request request) throws Exception {
        WikiPage page = this.getPage(context, request);
        PageData data = page.getData();
        this.saveAttributes(request, data);
        VersionInfo commitRecord = page.commit(data);
        SimpleResponse response = new SimpleResponse();
        if (commitRecord != null) {
            response.addHeader("Current-Version", commitRecord.getName());
        }
        context.recentChanges.updateRecentChanges(page);
        response.redirect(context.contextRoot, request.getResource());
        return response;
    }

    private void saveAttributes(Request request, PageData data) {
        this.setPageTypeAttribute(request, data);
        LinkedList<String> attrs = new LinkedList<String>();
        attrs.addAll(Arrays.asList(PageData.NON_SECURITY_ATTRIBUTES));
        attrs.addAll(Arrays.asList(PageData.SECURITY_ATTRIBUTES));
        attrs.add("Prune");
        for (String attribute : attrs) {
            if (this.isChecked(request, attribute)) {
                data.setAttribute(attribute);
                continue;
            }
            data.removeAttribute(attribute);
        }
        String suites = request.getInput("Suites");
        data.setOrRemoveAttribute("Suites", suites);
        String helpText = request.getInput("HelpText");
        data.setOrRemoveAttribute("Help", helpText);
    }

    private void setPageTypeAttribute(Request request, PageData data) {
        String pageType = this.getPageType(request);
        if (pageType == null) {
            return;
        }
        LinkedList<String> types = new LinkedList<String>();
        types.addAll(Arrays.asList(PageData.PAGE_TYPE_ATTRIBUTES));
        data.setAttribute(pageType);
        for (String type : types) {
            if (pageType.equals(type)) continue;
            data.removeAttribute(type);
        }
    }

    private String getPageType(Request request) {
        return request.getInput("PageType");
    }

    private boolean isChecked(Request request, String name) {
        return request.getInput(name) != null;
    }

    @Override
    public SecureOperation getSecureOperation() {
        return new AlwaysSecureOperation();
    }
}

