/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.responders.files;

import fitnesse.FitNesseContext;
import fitnesse.authentication.AlwaysSecureOperation;
import fitnesse.authentication.SecureOperation;
import fitnesse.authentication.SecureResponder;
import fitnesse.html.template.HtmlPage;
import fitnesse.html.template.PageTitle;
import fitnesse.http.Request;
import fitnesse.http.Response;
import fitnesse.http.SimpleResponse;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;
import util.FileUtil;

class DirectoryResponder
implements SecureResponder {
    private String resource;
    private File requestedDirectory;
    private FitNesseContext context;
    private SimpleDateFormat dateFormat = new SimpleDateFormat("MMM dd, yyyy, hh:mm a");

    public DirectoryResponder(String resource, File requestedFile) {
        this.resource = resource;
        this.requestedDirectory = requestedFile;
    }

    @Override
    public Response makeResponse(FitNesseContext context, Request request) throws Exception {
        this.context = context;
        if (!this.resource.endsWith("/")) {
            return this.setRedirectForDirectory(request.getQueryString());
        }
        if ("json".equals(request.getInput("format"))) {
            return this.makeDirectoryListingJsonPage();
        }
        return this.makeDirectoryListingPage(request);
    }

    private Response setRedirectForDirectory(String queryString) {
        SimpleResponse simpleResponse = new SimpleResponse();
        simpleResponse.redirect(this.context.contextRoot, this.resource + "/" + (queryString != null ? "?" + queryString : ""));
        return simpleResponse;
    }

    private Response makeDirectoryListingPage(Request request) throws UnsupportedEncodingException {
        HtmlPage page = this.context.pageFactory.newPage();
        page.setTitle("Files: " + this.resource);
        page.setPageTitle(new PageTitle("Files Section", this.resource, "/"));
        page.put("fileInfoList", this.makeFileInfo(FileUtil.getDirectoryListing(this.requestedDirectory)));
        page.setMainTemplate("directoryPage");
        SimpleResponse simpleResponse = new SimpleResponse();
        simpleResponse.setContent(page.html(request));
        return simpleResponse;
    }

    private Response makeDirectoryListingJsonPage() throws UnsupportedEncodingException {
        JSONArray listing = new JSONArray();
        for (FileInfo fileInfo : this.makeFileInfo(FileUtil.getDirectoryListing(this.requestedDirectory))) {
            JSONObject fiObject = new JSONObject();
            fiObject.put("name", (Object)fileInfo.getName());
            fiObject.put("size", (Object)fileInfo.getSize());
            fiObject.put("date", (Object)fileInfo.getDate());
            fiObject.put("directory", fileInfo.isDirectory());
            listing.put((Object)fiObject);
        }
        SimpleResponse simpleResponse = new SimpleResponse();
        simpleResponse.setContentType(Response.Format.JSON);
        simpleResponse.setContent(listing.toString());
        return simpleResponse;
    }

    @Override
    public SecureOperation getSecureOperation() {
        return new AlwaysSecureOperation();
    }

    private List<FileInfo> makeFileInfo(File[] files) {
        ArrayList<FileInfo> fileInfo = new ArrayList<FileInfo>();
        for (File file : files) {
            fileInfo.add(new FileInfo(file));
        }
        return fileInfo;
    }

    public class FileInfo {
        private File file;

        public FileInfo(File file) {
            this.file = file;
        }

        public File getFile() {
            return this.file;
        }

        public boolean isDirectory() {
            return this.file.isDirectory();
        }

        public String getName() {
            return this.file.getName();
        }

        public String getSize() {
            if (this.file.isDirectory()) {
                return "";
            }
            return this.file.length() + " bytes";
        }

        public String getDate() {
            return DirectoryResponder.this.dateFormat.format(new Date(this.file.lastModified()));
        }
    }
}

