/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.responders.run;

import fitnesse.html.template.HtmlPage;
import fitnesse.html.template.PageTitle;
import fitnesse.responders.ChunkingResponder;
import fitnesse.responders.run.SuiteResponder;
import fitnesse.testrunner.SuiteContentsFinder;
import fitnesse.testrunner.SuiteFilter;
import fitnesse.testrunner.run.PagePositions;
import fitnesse.wiki.PathParser;
import fitnesse.wiki.WikiPage;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PartitionPreviewResponder
extends ChunkingResponder {
    @Override
    protected void doSending() throws Exception {
        PagePositions pages = this.getPagesToRun();
        try {
            if (this.response.isTabSeparatedFormat()) {
                Writer writer = this.response.getWriter();
                pages.appendTo(writer, "\t");
            } else {
                this.makePartitionPreviewHtmlResponse(pages).render(this.response.getWriter(), this.request);
            }
        }
        finally {
            this.response.close();
        }
    }

    protected PagePositions getPagesToRun() {
        SuiteFilter filter = SuiteResponder.createSuiteFilter(this.request, this.page.getFullPath().toString());
        SuiteContentsFinder suiteTestFinder = new SuiteContentsFinder(this.page, filter, this.root);
        List<WikiPage> allPages = suiteTestFinder.getAllPagesToRunForThisSuite();
        return this.applyPartition(allPages);
    }

    protected PagePositions applyPartition(List<WikiPage> pages) {
        return this.context.testRunFactoryRegistry.findPagePositions(pages);
    }

    private HtmlPage makePartitionPreviewHtmlResponse(PagePositions pages) throws UnsupportedEncodingException {
        HtmlPage page = this.context.pageFactory.newPage();
        page.setTitle("Partitioning preview");
        page.setPageTitle(new PageTitle(PathParser.parse(this.request.getResource())));
        page.setNavTemplate("viewNav");
        page.put("partitionCount", this.getPartitionCount());
        page.put("pagePositions", pages);
        page.setMainTemplate("partitionPreview");
        return page;
    }

    private int getPartitionCount() {
        String qs = this.request.getQueryString();
        Pattern partitionCountPattern = Pattern.compile("partitionCount=([0-9]+)");
        Matcher matcher = partitionCountPattern.matcher(qs);
        if (matcher.find()) {
            return Integer.parseInt(matcher.group(1));
        }
        return 0;
    }
}

