/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.responders.run;

import fitnesse.FitNesseContext;
import fitnesse.authentication.SecureOperation;
import fitnesse.authentication.SecureResponder;
import fitnesse.authentication.SecureTestOperation;
import fitnesse.components.TraversalListener;
import fitnesse.html.template.HtmlPage;
import fitnesse.html.template.PageTitle;
import fitnesse.http.Request;
import fitnesse.http.Response;
import fitnesse.reporting.BaseFormatter;
import fitnesse.reporting.Formatter;
import fitnesse.reporting.InteractiveFormatter;
import fitnesse.reporting.RerunSuiteFormatter;
import fitnesse.reporting.SuiteHtmlFormatter;
import fitnesse.reporting.TestTextFormatter;
import fitnesse.reporting.history.HistoryPurger;
import fitnesse.reporting.history.JunitReFormatter;
import fitnesse.reporting.history.SuiteHistoryFormatter;
import fitnesse.reporting.history.SuiteXmlReformatter;
import fitnesse.reporting.history.TestXmlFormatter;
import fitnesse.responders.ChunkingResponder;
import fitnesse.responders.WikiImporter;
import fitnesse.responders.WikiImportingResponder;
import fitnesse.responders.WikiImportingTraverser;
import fitnesse.responders.WikiPageActions;
import fitnesse.testrunner.MultipleTestsRunner;
import fitnesse.testrunner.RunningTestingTracker;
import fitnesse.testrunner.SuiteContentsFinder;
import fitnesse.testrunner.SuiteFilter;
import fitnesse.testrunner.run.TestRun;
import fitnesse.testsystems.ConsoleExecutionLogListener;
import fitnesse.testsystems.ExecutionLogListener;
import fitnesse.testsystems.TestExecutionException;
import fitnesse.testsystems.TestSummary;
import fitnesse.wiki.PageCrawler;
import fitnesse.wiki.PageData;
import fitnesse.wiki.PageType;
import fitnesse.wiki.PathParser;
import fitnesse.wiki.WikiImportProperty;
import fitnesse.wiki.WikiPage;
import fitnesse.wiki.WikiPagePath;
import fitnesse.wiki.WikiPageUtil;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;
import util.FileUtil;

public class SuiteResponder
extends ChunkingResponder
implements SecureResponder {
    private static final Logger LOG = Logger.getLogger(SuiteResponder.class.getName());
    private static final String NOT_FILTER_ARG = "excludeSuiteFilter";
    private static final String AND_FILTER_ARG = "runTestsMatchingAllTags";
    private static final String OR_FILTER_ARG_1 = "runTestsMatchingAnyTag";
    private static final String OR_FILTER_ARG_2 = "suiteFilter";
    static final RunningTestingTracker runningTestingTracker = new RunningTestingTracker();
    private final WikiImporter wikiImporter;
    private SuiteHistoryFormatter suiteHistoryFormatter;
    private Formatter rerunFormatter;
    private PageData data;
    private String testRunId;
    private BaseFormatter mainFormatter;
    private volatile boolean isClosed = false;
    private boolean debug = false;
    private boolean remoteDebug = false;
    private boolean includeHtml = false;
    private int exitCode;
    private Request request;

    public SuiteResponder() {
        this(new WikiImporter());
    }

    public SuiteResponder(WikiImporter wikiImporter) {
        this.wikiImporter = wikiImporter;
    }

    private boolean isInteractive() {
        return this.mainFormatter instanceof InteractiveFormatter;
    }

    @Override
    public Response makeResponse(FitNesseContext context, Request request) throws Exception {
        this.request = request;
        Response result = super.makeResponse(context, request);
        if (result != this.response) {
            return result;
        }
        this.testRunId = runningTestingTracker.generateNextTicket();
        this.response.addHeader("X-FitNesse-Test-Id", this.testRunId);
        return this.response;
    }

    @Override
    protected void doSending() throws Exception {
        this.debug |= this.request.hasInput("debug");
        this.remoteDebug |= this.request.hasInput("remote_debug");
        this.includeHtml |= this.request.hasInput("includehtml");
        this.data = this.page.getData();
        this.createMainFormatter();
        this.rerunFormatter = this.createRerunFormatter();
        if (this.isInteractive()) {
            this.makeHtml().render(this.response.getWriter(), this.request);
        } else {
            this.doExecuteTests();
        }
        this.closeHtmlResponse(this.exitCode);
        this.cleanHistoryForSuite();
    }

    private void cleanHistoryForSuite() {
        String testHistoryDays = this.context.getProperty("test.history.days");
        if (this.withSuiteHistoryFormatter() && StringUtils.isNumeric((CharSequence)testHistoryDays)) {
            new HistoryPurger(this.context.getTestHistoryDirectory(), Integer.parseInt(testHistoryDays)).deleteTestHistoryOlderThanDays(this.path);
        }
    }

    public void doExecuteTests() {
        if (WikiImportProperty.isImported(this.data)) {
            this.importWikiPages();
        }
        try {
            this.performExecution();
        }
        catch (Exception e) {
            LOG.log(Level.INFO, "Test system terminated with exception", e);
        }
        this.exitCode = this.mainFormatter.getErrorCount();
    }

    public void importWikiPages() {
        if (this.response.isXmlFormat() || !WikiImportProperty.isAutoUpdated(this.data != null ? this.data : this.page.getData())) {
            return;
        }
        try {
            this.addToResponse("<span class=\"meta\">Updating imported content...</span><span class=\"meta\">");
            new WikiImportingTraverser(this.wikiImporter, this.page).traverse(new TraversalListener<Object>(){

                @Override
                public void process(Object pageOrError) {
                    if (pageOrError instanceof WikiImportingTraverser.ImportError) {
                        WikiImportingTraverser.ImportError error = (WikiImportingTraverser.ImportError)pageOrError;
                        SuiteResponder.this.addToResponse(" " + error.toString() + ".");
                    }
                }
            });
            this.addToResponse(" Done.");
            this.data = this.page.getData();
        }
        catch (IOException e) {
            this.addToResponse(" Import failed: " + e.toString() + ".");
        }
        finally {
            this.addToResponse("</span>");
        }
    }

    private HtmlPage makeHtml() {
        PageCrawler pageCrawler = this.page.getPageCrawler();
        WikiPagePath fullPath = pageCrawler.getFullPath();
        String fullPathName = PathParser.render(fullPath);
        HtmlPage htmlPage = this.context.pageFactory.newPage();
        htmlPage.setTitle(this.getTitle() + ": " + fullPathName);
        htmlPage.setPageTitle(new PageTitle(this.getTitle(), fullPath, this.data.getAttribute("Suites")));
        htmlPage.setNavTemplate("testNav.vm");
        htmlPage.put("actions", new WikiPageActions(this.page));
        htmlPage.setMainTemplate(this.mainTemplate());
        htmlPage.put("testExecutor", new TestExecutor());
        htmlPage.setFooterTemplate("wikiFooter.vm");
        htmlPage.put("headerContent", new WikiPageHeaderRenderer());
        htmlPage.put("footerContent", new WikiPageFooterRenderer());
        htmlPage.setErrorNavTemplate("errorNavigator");
        htmlPage.put("multipleTestsRun", this.isMultipleTestsRun());
        WikiImportingResponder.handleImportProperties(htmlPage, this.page);
        if (this.rerunFormatter != null) {
            htmlPage.put("rerunPage", this.getRerunPageName());
        }
        return htmlPage;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    private boolean isMultipleTestsRun() {
        return PageType.fromWikiPage(this.page) == PageType.SUITE;
    }

    protected void addFormatters(MultipleTestsRunner runner) {
        runner.addTestSystemListener(this.mainFormatter);
        if (this.rerunFormatter != null) {
            runner.addTestSystemListener(this.rerunFormatter);
        }
        if (this.withSuiteHistoryFormatter()) {
            this.addHistoryFormatter(runner);
        } else {
            runner.addExecutionLogListener(new ConsoleExecutionLogListener());
        }
        if (this.mainFormatter instanceof ExecutionLogListener) {
            runner.addExecutionLogListener((ExecutionLogListener)((Object)this.mainFormatter));
        }
        for (Formatter formatter : this.context.formatterFactory.createFormatters()) {
            runner.addTestSystemListener(formatter);
        }
        if (this.context.testSystemListener != null) {
            runner.addTestSystemListener(this.context.testSystemListener);
        }
    }

    private boolean withSuiteHistoryFormatter() {
        return !this.request.hasInput("nohistory");
    }

    protected void addHistoryFormatter(MultipleTestsRunner runner) {
        SuiteHistoryFormatter historyFormatter = this.getSuiteHistoryFormatter();
        runner.addTestSystemListener(historyFormatter);
        runner.addExecutionLogListener(historyFormatter);
    }

    private void createMainFormatter() {
        this.mainFormatter = this.response.isXmlFormat() ? this.newXmlFormatter() : (this.response.isTextFormat() ? this.newTextFormatter() : (this.response.isJunitFormat() ? this.newJunitFormatter() : this.newHtmlFormatter()));
    }

    protected Formatter createRerunFormatter() throws IOException {
        return new RerunSuiteFormatter(this.getRerunPageFile());
    }

    protected File getRerunPageFile() {
        return new File(this.context.getRootPagePath(), this.getRerunPageName() + ".wiki");
    }

    protected String getRerunPageName() {
        PageCrawler pageCrawler = this.page.getPageCrawler();
        WikiPagePath fullPath = pageCrawler.getFullPath();
        String fullPathName = PathParser.render(fullPath);
        return "RerunLastFailures_" + fullPathName.replace(".", "-");
    }

    protected String getTitle() {
        return "Test Results";
    }

    protected String mainTemplate() {
        return "testPage";
    }

    protected BaseFormatter newXmlFormatter() {
        SuiteXmlReformatter xmlFormatter = new SuiteXmlReformatter(this.context, this.page, this.response.getWriter(), this.getSuiteHistoryFormatter());
        if (this.includeHtml) {
            xmlFormatter.includeHtml();
        }
        if (!this.isMultipleTestsRun()) {
            xmlFormatter.includeInstructions();
        }
        return xmlFormatter;
    }

    protected BaseFormatter newTextFormatter() {
        return new TestTextFormatter(this.response);
    }

    protected BaseFormatter newJunitFormatter() {
        return new JunitReFormatter(this.context, this.page, this.response.getWriter(), this.getSuiteHistoryFormatter());
    }

    protected BaseFormatter newHtmlFormatter() {
        return new SuiteHtmlFormatter(this.page, this.isMultipleTestsRun(), this.response.getWriter());
    }

    protected void performExecution() throws TestExecutionException {
        MultipleTestsRunner runner = this.newMultipleTestsRunner(this.getPagesToRun());
        runningTestingTracker.addStartedProcess(this.testRunId, runner);
        if (this.isInteractive()) {
            ((InteractiveFormatter)this.mainFormatter).setTrackingId(this.testRunId);
        }
        try {
            runner.executeTestPages();
        }
        finally {
            runningTestingTracker.removeEndedProcess(this.testRunId);
        }
    }

    protected List<WikiPage> getPagesToRun() {
        SuiteFilter filter = SuiteResponder.createSuiteFilter(this.request, this.page.getFullPath().toString());
        SuiteContentsFinder suiteTestFinder = new SuiteContentsFinder(this.page, filter, this.root);
        return suiteTestFinder.getAllPagesToRunForThisSuite();
    }

    protected MultipleTestsRunner newMultipleTestsRunner(List<WikiPage> pages) {
        TestRun run = this.createRunProvider(pages);
        MultipleTestsRunner runner = new MultipleTestsRunner(run, this.context.testSystemFactory);
        runner.setRunInProcess(this.debug);
        runner.setEnableRemoteDebug(this.remoteDebug);
        this.addFormatters(runner);
        return runner;
    }

    protected TestRun createRunProvider(List<WikiPage> pages) {
        return this.context.testRunFactoryRegistry.createRun(pages);
    }

    @Override
    public SecureOperation getSecureOperation() {
        return new SecureTestOperation();
    }

    public void addToResponse(String output) {
        if (!this.isClosed()) {
            try {
                this.response.add(output);
            }
            catch (IOException e) {
                LOG.log(Level.WARNING, "Unable to send output", e);
            }
        }
    }

    synchronized boolean isClosed() {
        return this.isClosed;
    }

    synchronized void setClosed() {
        this.isClosed = true;
    }

    void closeHtmlResponse(int exitCode) throws IOException {
        if (!this.isClosed()) {
            this.setClosed();
            this.response.addTrailingHeader("Exit-Code", String.valueOf(exitCode));
            this.response.close();
        }
    }

    public Response getResponse() {
        return this.response;
    }

    public static SuiteFilter createSuiteFilter(Request request, String suitePath) {
        return new SuiteFilter(SuiteResponder.getOrTagFilter(request), SuiteResponder.getNotSuiteFilter(request), SuiteResponder.getAndTagFilters(request), SuiteResponder.getSuiteFirstTest(request, suitePath));
    }

    private static String getOrTagFilter(Request request) {
        return request != null ? SuiteResponder.getOrFilterString(request) : null;
    }

    private static String getOrFilterString(Request request) {
        String orFilterString = null;
        orFilterString = request.getInput(OR_FILTER_ARG_1) != null ? request.getInput(OR_FILTER_ARG_1) : request.getInput(OR_FILTER_ARG_2);
        return orFilterString;
    }

    private static String getNotSuiteFilter(Request request) {
        return request != null ? request.getInput(NOT_FILTER_ARG) : null;
    }

    private static String getAndTagFilters(Request request) {
        return request != null ? request.getInput(AND_FILTER_ARG) : null;
    }

    private static String getSuiteFirstTest(Request request, String suiteName) {
        String startTest = null;
        if (request != null) {
            startTest = request.getInput("firstTest");
        }
        if (startTest != null && startTest.indexOf(suiteName) != 0) {
            startTest = suiteName + "." + startTest;
        }
        return startTest;
    }

    public static String makePageHistoryFileName(FitNesseContext context, WikiPage page, TestSummary counts, long time) {
        return String.format("%s/%s/%s", context.getTestHistoryDirectory(), page.getFullPath().toString(), SuiteResponder.makeResultFileName(counts, time));
    }

    public static String makeResultFileName(TestSummary summary, long time) {
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMddHHmmss");
        String datePart = format.format(new Date(time));
        return String.format("%s_%d_%d_%d_%d.xml", datePart, summary.getRight(), summary.getWrong(), summary.getIgnores(), summary.getExceptions());
    }

    private SuiteHistoryFormatter getSuiteHistoryFormatter() {
        if (this.suiteHistoryFormatter == null) {
            HistoryWriterFactory source = new HistoryWriterFactory();
            this.suiteHistoryFormatter = new SuiteHistoryFormatter(this.context, this.page, source);
        }
        return this.suiteHistoryFormatter;
    }

    public static class HistoryWriterFactory
    implements TestXmlFormatter.WriterFactory {
        @Override
        public Writer getWriter(FitNesseContext context, WikiPage page, TestSummary counts, long time) throws IOException {
            File resultPath = new File(SuiteResponder.makePageHistoryFileName(context, page, counts, time));
            File resultDirectory = new File(resultPath.getParent());
            if (!resultDirectory.exists()) {
                resultDirectory.mkdirs();
            }
            File resultFile = new File(resultDirectory, resultPath.getName());
            return new PrintWriter(resultFile, FileUtil.CHARENCODING);
        }
    }

    public class TestExecutor {
        public void execute() {
            SuiteResponder.this.doExecuteTests();
        }
    }

    public class WikiPageFooterRenderer {
        public String render() {
            return WikiPageUtil.getFooterPageHtml(SuiteResponder.this.page);
        }
    }

    public class WikiPageHeaderRenderer {
        public String render() {
            return WikiPageUtil.getHeaderPageHtml(SuiteResponder.this.page);
        }
    }
}

