/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.responders.testHistory;

import fitnesse.reporting.history.MostRecentPageHistoryReader;
import fitnesse.reporting.history.TestResultRecord;
import fitnesse.wiki.WikiPage;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.LinkedList;
import java.util.List;
import util.GracefulNamer;

public class SuiteOverviewTree {
    private final TreeItem treeRoot = new TreeItem("root", "");
    private SimpleDateFormat dateFormatter = new SimpleDateFormat("yyyyMMddHHmmss");

    public SuiteOverviewTree(List<WikiPage> wikiPagelist) {
        this.makeTree(SuiteOverviewTree.convertToPageList(wikiPagelist));
    }

    private void makeTree(List<String> pageList) {
        for (String pageName : pageList) {
            String[] splits = pageName.split("\\.");
            this.treeRoot.addItem(splits, 0);
        }
        this.compactTree();
    }

    public TreeItem getTreeRoot() {
        return this.treeRoot;
    }

    private static List<String> convertToPageList(List<WikiPage> wikiPagelist) {
        LinkedList<String> allPages = new LinkedList<String>();
        for (WikiPage aPage : wikiPagelist) {
            try {
                allPages.add(aPage.getFullPath().toString());
            }
            catch (Exception e) {
                allPages.add("There was also a probem getting the path of one page.");
            }
        }
        return allPages;
    }

    public void countResults() {
        RecursiveTreeMethod countResults = new RecursiveTreeMethod(){

            @Override
            public boolean shouldDoItemBeforeBranches() {
                return false;
            }

            @Override
            public void doMethod(TreeItem item) {
                item.calculateResults();
            }
        };
        this.treeRoot.doRecursive(countResults, 0);
    }

    public void findLatestResults(final File historyDirectory) {
        RecursiveTreeMethod findLatestResult = new RecursiveTreeMethod(){

            @Override
            public void doMethod(TreeItem item) {
                if (item.isTest()) {
                    File directory = new File(historyDirectory, item.fullName);
                    MostRecentPageHistoryReader reader = new MostRecentPageHistoryReader(directory);
                    item.result = reader.findMostRecentTestRun();
                }
            }
        };
        this.treeRoot.doRecursive(findLatestResult, 0);
    }

    private void compactTree() {
        RecursiveTreeMethod compactBranch = new RecursiveTreeMethod(){

            @Override
            public void doMethod(TreeItem item) {
                item.compactWithChildIfOnlyOneChild();
            }
        };
        this.treeRoot.doRecursive(compactBranch, 0);
    }

    abstract class RecursiveTreeMethod {
        RecursiveTreeMethod() {
        }

        public boolean shouldDoItemBeforeBranches() {
            return true;
        }

        public abstract void doMethod(TreeItem var1);
    }

    public class TreeItem {
        private String name;
        private String fullName;
        int testsPassed = 0;
        int testsUnrun = 0;
        int testsFailed = 0;
        List<TreeItem> branches = new LinkedList<TreeItem>();
        TestResultRecord result = null;

        public int getTestsPassed() {
            return this.testsPassed;
        }

        public int getTestsUnrun() {
            return this.testsUnrun;
        }

        public int getTestsFailed() {
            return this.testsFailed;
        }

        private double calcPercentOfTotalTests(int value) {
            int totalTests = this.testsPassed + this.testsUnrun + this.testsFailed;
            return (double)Math.round(1000.0 * (double)value / (double)totalTests) / 10.0;
        }

        private String makePercentageOfTotalString(int value) {
            double percentage = this.calcPercentOfTotalTests(value);
            if (this.calcPercentOfTotalTests(value) < 99.95) {
                return "(" + (int)percentage + "%)";
            }
            return "";
        }

        public String getPassedPercentString() {
            return this.makePercentageOfTotalString(this.testsPassed);
        }

        public String getUnrunPercentString() {
            return this.makePercentageOfTotalString(this.testsUnrun);
        }

        public String getFailedPercentString() {
            return this.makePercentageOfTotalString(this.testsFailed);
        }

        public double getPassedPercent() {
            return this.calcPercentOfTotalTests(this.testsPassed);
        }

        public double getUnrunPercent() {
            return this.calcPercentOfTotalTests(this.testsUnrun);
        }

        public double getFailedPercent() {
            return this.calcPercentOfTotalTests(this.testsFailed);
        }

        public String getName() {
            return GracefulNamer.regrace(this.name);
        }

        public String getFullName() {
            return this.fullName;
        }

        public String getHistoryUrl() {
            String url = this.getFullName();
            if (this.result != null) {
                url = url + "?pageHistory&resultDate=";
                url = url + SuiteOverviewTree.this.dateFormatter.format(this.result.getDate());
            }
            return url;
        }

        public void compactWithChildIfOnlyOneChild() {
            TreeItem child;
            if (this.branches.size() == 1 && !(child = this.branches.get(0)).isTest()) {
                this.name = this.name + "." + child.name;
                this.fullName = this.fullName + "." + child.name;
                this.branches = child.branches;
                this.compactWithChildIfOnlyOneChild();
            }
        }

        TreeItem(String branchName, String branchFullName) {
            this.name = branchName;
            this.fullName = branchFullName;
        }

        public List<TreeItem> getBranches() {
            return this.branches;
        }

        public void calculateResults() {
            this.testsPassed = 0;
            this.testsUnrun = 0;
            this.testsFailed = 0;
            if (this.isTest()) {
                if (this.result == null) {
                    ++this.testsUnrun;
                } else if (this.result.getExceptions() == 0 && this.result.getWrong() == 0) {
                    ++this.testsPassed;
                } else {
                    ++this.testsFailed;
                }
            } else {
                for (TreeItem branch : this.branches) {
                    this.testsUnrun += branch.testsUnrun;
                    this.testsPassed += branch.testsPassed;
                    this.testsFailed += branch.testsFailed;
                }
            }
        }

        public String toString() {
            return this.name;
        }

        void addItem(String[] itemPath, int currentIndex) {
            if (currentIndex < itemPath.length) {
                if (this.nameSameAsLastName(itemPath[currentIndex])) {
                    this.branches.get(this.branches.size() - 1).addItem(itemPath, ++currentIndex);
                } else {
                    String branchName = itemPath[currentIndex];
                    String branchFullName = this.fullName;
                    branchFullName = branchFullName + (this.fullName.isEmpty() ? branchName : "." + branchName);
                    TreeItem branch = new TreeItem(branchName, branchFullName);
                    this.branches.add(branch);
                    branch.addItem(itemPath, ++currentIndex);
                }
            }
        }

        private boolean nameSameAsLastName(String currentName) {
            return !this.branches.isEmpty() && this.branches.get((int)(this.branches.size() - 1)).name.equals(currentName);
        }

        public boolean isTest() {
            return this.branches.isEmpty();
        }

        public String getCssClass() {
            if (this.testsFailed != 0) {
                return "fail";
            }
            if (this.testsUnrun != 0) {
                return "unrun";
            }
            return "done";
        }

        void doRecursive(RecursiveTreeMethod method, int level) {
            if (method.shouldDoItemBeforeBranches() && level != 0) {
                method.doMethod(this);
            }
            for (TreeItem branch : this.branches) {
                branch.doRecursive(method, level + 1);
            }
            if (!method.shouldDoItemBeforeBranches() && level != 0) {
                method.doMethod(this);
            }
        }
    }
}

