/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.responders.versions;

import fitnesse.FitNesseContext;
import fitnesse.authentication.SecureOperation;
import fitnesse.authentication.SecureReadOperation;
import fitnesse.html.template.HtmlPage;
import fitnesse.html.template.PageTitle;
import fitnesse.http.Request;
import fitnesse.http.Response;
import fitnesse.http.SimpleResponse;
import fitnesse.responders.BasicResponder;
import fitnesse.wiki.PageData;
import fitnesse.wiki.PathParser;
import fitnesse.wiki.VersionInfo;
import fitnesse.wiki.WikiPage;
import fitnesse.wiki.WikiPageProperty;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;

public class VersionSelectionResponder
extends BasicResponder {
    @Override
    public Response makeResponse(FitNesseContext context, Request request) throws Exception {
        WikiPage page = this.getPage(context, request);
        PageData pageData = page.getData();
        List<VersionInfo> versions = VersionSelectionResponder.getVersionsList(page);
        HtmlPage html = context.pageFactory.newPage();
        html.setTitle("Version Selection: " + request.getResource());
        html.setPageTitle(new PageTitle("Version Selection", PathParser.parse(request.getResource()), pageData.getAttribute("Suites")));
        html.put("lastModified", this.makeLastModifiedTag(pageData));
        html.put("versions", versions);
        html.setNavTemplate("viewNav");
        html.put("viewLocation", request.getResource());
        html.setMainTemplate("versionSelection");
        SimpleResponse response = new SimpleResponse();
        response.setContent(html.html(request));
        return response;
    }

    private String makeLastModifiedTag(PageData pageData) {
        String username = pageData.getAttribute("LastModifyingUser");
        String dateString = pageData.getAttribute("LastModified");
        if (dateString == null) {
            dateString = "";
        }
        if (!dateString.isEmpty()) {
            try {
                Date date = WikiPageProperty.getTimeFormat().parse(dateString);
                dateString = " on " + new SimpleDateFormat("MMM dd, yyyy").format(date) + " at " + new SimpleDateFormat("hh:mm:ss a").format(date);
            }
            catch (ParseException e) {
                dateString = " on " + dateString;
            }
        }
        if (username == null || "".equals(username)) {
            return "Last modified anonymously" + dateString;
        }
        return "Last modified by " + username + dateString;
    }

    public static List<VersionInfo> getVersionsList(WikiPage page) {
        ArrayList<VersionInfo> list = new ArrayList<VersionInfo>(page.getVersions());
        Collections.sort(list);
        Collections.reverse(list);
        return list;
    }

    @Override
    public SecureOperation getSecureOperation() {
        return new SecureReadOperation();
    }
}

