/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.slim;

import fitnesse.slim.NameTranslator;
import fitnesse.slim.NameTranslatorIdentity;
import fitnesse.slim.SlimError;
import fitnesse.slim.SlimExecutionContext;
import fitnesse.slim.SlimFactory;
import fitnesse.slim.SlimService;
import fitnesse.slim.StatementExecutor;
import fitnesse.slim.StatementExecutorInterface;
import fitnesse.slim.StatementTimeoutExecutor;
import fitnesse.slim.fixtureInteraction.DefaultInteraction;
import fitnesse.slim.fixtureInteraction.FixtureInteraction;

public class JavaSlimFactory
extends SlimFactory {
    private final NameTranslator identityTranslator = new NameTranslatorIdentity();
    private final Integer timeout;
    private final boolean verbose;
    private final FixtureInteraction interaction;

    private JavaSlimFactory(FixtureInteraction interaction, Integer timeout, boolean verbose) {
        this.interaction = interaction;
        this.timeout = timeout;
        this.verbose = verbose;
    }

    @Override
    public StatementExecutorInterface getStatementExecutor() {
        StatementExecutorInterface statementExecutor = new StatementExecutor(new SlimExecutionContext(this.interaction));
        if (this.timeout != null) {
            statementExecutor = StatementTimeoutExecutor.decorate(statementExecutor, this.timeout);
        }
        return statementExecutor;
    }

    @Override
    public NameTranslator getMethodNameTranslator() {
        return this.getIdentityTranslator();
    }

    @Override
    public boolean isVerbose() {
        return this.verbose;
    }

    private NameTranslator getIdentityTranslator() {
        return this.identityTranslator;
    }

    public static SlimFactory createJavaSlimFactory(SlimService.Options options) {
        return JavaSlimFactory.createJavaSlimFactory(options.interaction, options.statementTimeout, options.verbose);
    }

    public static SlimFactory createJavaSlimFactory(FixtureInteraction interaction, Integer timeout, boolean verbose) {
        return new JavaSlimFactory(interaction, timeout, verbose);
    }

    public static FixtureInteraction createInteraction(String interactionClassName) {
        return JavaSlimFactory.createInteraction(interactionClassName, ClassLoader.getSystemClassLoader());
    }

    public static FixtureInteraction createInteraction(String interactionClassName, ClassLoader classLoader) {
        if (interactionClassName == null) {
            return new DefaultInteraction();
        }
        try {
            return (FixtureInteraction)classLoader.loadClass(interactionClassName).newInstance();
        }
        catch (Exception e) {
            throw new SlimError(e);
        }
    }
}

