/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.slim;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;

class LoggingOutputStream
extends ByteArrayOutputStream {
    private String lineSeparator;
    private PrintStream logger;
    private String level;

    public LoggingOutputStream(PrintStream logger, String level) {
        this.logger = logger;
        this.level = level;
        this.lineSeparator = System.getProperty("line.separator");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() throws IOException {
        String record;
        LoggingOutputStream loggingOutputStream = this;
        synchronized (loggingOutputStream) {
            super.flush();
            record = this.toString();
            super.reset();
        }
        if (record.length() == 0 || record.equals(this.lineSeparator)) {
            return;
        }
        record = record.replace("\n", "\n" + this.level + " :");
        this.logger.println(this.level + ".:" + record);
    }
}

